#include "mbed.h"
#include "ili9163lcd.h"
//#include "hcsr04.h"
#include "StrLib.h"
#include "HCSR04.h"

ILI9163 TFT(D13,D11,D10,D9,D8);
HCSR04  usensor(D4, D2);
Ticker ticker;
Timer debounce;
Timer debounce1;

int dist = 0;
int postotakPopunjenosti = 0;
bool startFlag = false;
bool resetFlag = false;

DigitalOut green(A2);
DigitalOut yellow(A1);
DigitalOut red(A0);
InterruptIn startBtn(A4, PullDown);
InterruptIn resetBtn(A5, PullDown);

void start();
void reset();
void sensorRead();
void defaultScreen();
void displayState();

int main() {
    ticker.attach(&sensorRead, 1.0);

    debounce.start(); //ograničava pozivanje start funkcije ispod
    startBtn.rise(&start);
    debounce1.start();
    resetBtn.rise(&reset);
     
    start:
    defaultScreen();
      
    while(1) {
        
         
        if(startFlag == false) {
            
            TFT.setFont((unsigned char*)font5x8); 
            TFT.putS("Za pokretanje: ", TFT.lcdTextX(2), TFT.lcdTextY(2),Black, White);
            TFT.putS("pritisnite start", TFT.lcdTextX(2), TFT.lcdTextY(4),Black, White);            
        } else {          
            defaultScreen();
            
            while(1) {
                if (resetFlag == true) {break;}
                displayState();
                if(postotakPopunjenosti <= 30) {
                    green = 1;
                    yellow = 0;
                    red = 0;
                } else if (postotakPopunjenosti <= 80 && postotakPopunjenosti > 30) {
                    green = 0;
                    yellow = 1;
                    red = 0;   
                } else if (postotakPopunjenosti > 80) {
                    green = 0;
                    yellow = 0;
                    red = 1;   
                }    
            }
            green = 0;
            yellow = 0;
            red = 0;
            goto start;
        }    
  
    }  
    
}

void start() {
    if(debounce.read_ms() > 200) {
        startFlag = true;
        resetFlag = false;
        debounce.reset();
    }
}

void reset() {
    if(debounce1.read_ms() > 200) {
        startFlag = false;
        resetFlag = true;
        debounce1.reset();
    }
}

void sensorRead() {
    dist = usensor.distance(1);
}    

void defaultScreen() {
    TFT.init(LCD_ORIENTATION1);
    TFT.clearDisplay(Black);
    TFT.rectangle(4, 4, 124, 124, Green);
}

void displayState(){
    
    if(dist >= 30 ) {
        postotakPopunjenosti = 0;    
    } else {
        postotakPopunjenosti = ((30 - dist) / 30.0)*100;
    }
    
    string strPostotkaPop = I2A(postotakPopunjenosti, 10, 3); 
    const char *prvi = strPostotkaPop.c_str();                
    string strUdaljenosti = I2A(dist, 10, 3);
    const char *drugi = strUdaljenosti.c_str();
    
    if( 0 <= postotakPopunjenosti && postotakPopunjenosti <= 100 ) {          
        TFT.setFont((unsigned char*)font5x8); 
        TFT.putS("Popunjenost", TFT.lcdTextX(2), TFT.lcdTextY(2),Black, White);
        TFT.putS("spremnika:", TFT.lcdTextX(2), TFT.lcdTextY(4),Black, White);
        TFT.putS(prvi, TFT.lcdTextX(2), TFT.lcdTextY(6),Black, White);
        TFT.putS("%", TFT.lcdTextX(5), TFT.lcdTextY(6),Black, White);
        
        TFT.setFont((unsigned char*)font5x8);
        TFT.putS("Za info udaljenost", TFT.lcdTextX(2), TFT.lcdTextY(10),Black, White); 
        TFT.putS("od senzora(cm):", TFT.lcdTextX(2), TFT.lcdTextY(12),Black, White); 
        TFT.putS(drugi, TFT.lcdTextX(2), TFT.lcdTextY(14),Black, White);
    }
}    
