#include "mbed.h"
#include "RFDuino.h"

PwmOut red(LED_RED);
PwmOut green(LED_GREEN);
PwmOut blue(LED_BLUE);

RFDuino rfd(PTC4, PTC3); //defaults to 9600 baud

typedef union {
    float fp;
    unsigned int uint_32;
} intFloat;

typedef struct  {
    intFloat red;
    intFloat green;
    intFloat blue;
} RGB;

void bblink(void)
{
    blue=0;
    wait(0.5);
    blue=1;
    wait(0.5);
}

void byteSwap(RGB* rgb)
{
    intFloat temp;

    temp.uint_32 = __REV(rgb->red.uint_32);
    rgb->red.fp = temp.fp;

    temp.uint_32 = __REV(rgb->blue.uint_32);
    rgb->blue.fp = temp.fp;

    temp.uint_32 = __REV(rgb->green.uint_32);
    rgb->green.fp = temp.fp;

}

int main()
{
    RGB rgb = {1.0f, 1.0f, 1.0f};
    
    red = blue = green = 1.0f;
    wait(2.0f); //make sure to wait at least 2 seconds before handshake

    //flash red and halt here if rfduino is not on the line
    if(!rfd.handshake()) {
        while(1) {
            red = !red;
            wait(0.2f);
        }
    }

    //wait for a connection
    while(!rfd.isConnected()) {
        bblink();
    }

    while(1) {
        if(rfd.readable()) {
            //copy data into data struct
            rfd.read((unsigned char*)&rgb.red, sizeof(rgb));
            
            //re-arrange bytes
            byteSwap(&rgb);

            //set pwms
            red   = rgb.red.fp;
            blue  = rgb.blue.fp;
            green = rgb.green.fp;
        }
    }
}
