/* RFDuino Interface Library
 * Copyright (c) 2006-2013 Your Name Here
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "RFDuino.h"

//Commands
int const HANDSHAKE = 0x11;
int const CONNECTED = 0x22;
int const TRANSMIT  = 0x33;
int const RECEIVE   = 0x44;

RFDuino::RFDuino(PinName tx, PinName rx): rfd(tx,rx)
{
    //init
    dataFlag=false;
}



//rfduino seems to take a few seconds to be ready
//for serial comm
bool RFDuino::handshake(void)
{
    unsigned char temp = 0;
    // make sure RX irq is detached
    rfd.attach(NULL);
    // send a handshake byte
    rfd.putc(HANDSHAKE);
    // give some time for data to be sent
    wait(0.1);

    if(rfd.readable()) {
        temp = rfd.getc();
        //attach Serial isr
        rfd.attach(this, &RFDuino::receive_isr);
    }

    return (temp) ? 1 : 0;
}

bool RFDuino::readable(void) const
{
    return dataFlag;
}

bool RFDuino::isConnected(void)
{
    unsigned char temp = 0;
    // make sure RX irq is detached
    rfd.attach(NULL);
    // send a byte and read the response
    rfd.putc(CONNECTED);
    temp = rfd.getc();

    //attach Serial isr
    rfd.attach(this, &RFDuino::receive_isr);

    return (temp) ? 1 : 0;
}

bool RFDuino::transmit(const unsigned char *buff, const int len)
{
    //needs to be less than 255 bytes
    if (len > buff_size) {
        return 0;
    }

    // make sure RX irq is detached
    rfd.attach(NULL);

    //send command
    rfd.putc(TRANSMIT);
    rfd.putc(static_cast<unsigned char>(len));
    for(int i=0; i<len; i++) {
        rfd.putc(buff[i]);
    }

    //attach Serial isr
    rfd.attach(this, &RFDuino::receive_isr);

    return 1;
}


int RFDuino::read(unsigned char* buff, const int size)
{
    memcpy(buff, data.buff, size/*data.len*/);
    dataFlag = false;

    return data.len;
}

void RFDuino::receive_isr()
{
    if(rfd.getc() == RECEIVE) {
        data.len = static_cast<int>(rfd.getc());
        if(data.len > buff_size) {
            // signal an error or reset??
            data.len = buff_size;
        }

        for(int i=0; i<data.len; i++) {
            data.buff[i] = rfd.getc();
        }
        //handshake
        //rfd.putc(HANDSHAKE);

        dataFlag=true;
    } else {
        //we dont know this command, read and disregard
        while(rfd.readable()) {
            char c = rfd.getc();
            c = c;
        }
    }
}





