#include "mbed.h"
#include "x_nucleo_iks01a1.h"

#define SERVO_IDLE (0.00153)

static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);
static MotionSensor *accelerometer = mems_expansion_board->GetAccelerometer();
PwmOut servo(D3);

int main(int argc, char** argv)
{
    int32_t axes[3];
    float pwmWidth;
    
    /* Initialize PWM to 50Hz*/
    servo.period(0.020);
    servo.pulsewidth(SERVO_IDLE);
        
    while(1){
        /* SENSE accelerometer X axis */
        accelerometer->Get_X_Axes(axes);
        
        /* COMPUTE PWM width */
        pwmWidth = SERVO_IDLE + axes[0] * 1e-7;
        
        /* ACTUATE Servo Motor according to accelerometer value */
        servo.pulsewidth(pwmWidth);
        
        /* Wait 50ms */
        wait(0.05);
    }
}

