#include "mbed.h"
#include "x_nucleo_iks01a1.h"

#define NCOLUMNS 80

static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);
static MotionSensor *accelerometer = mems_expansion_board->GetAccelerometer();

int main(int argc, char** argv)
{
    char bar[NCOLUMNS];
    int32_t axes[3];
           
    while(1){
        /* SENSE accelerometer X axis */
        accelerometer->Get_X_Axes(axes);
        
        /* COMPUTE User Interface  */
        memset(bar, 0, NCOLUMNS);
        for(int i=0; i<NCOLUMNS; i++)
            if(abs(axes[0])*NCOLUMNS/1000 > i)
                bar[i] = '#';
        
        /* COMMUNICATE it to PC */
        printf("[%04i]%s\r\n", axes[0], bar);
        
        /* Wait 50ms */
        wait(0.05);
    }
}

