/*
The MIT License (MIT)

Copyright (c) 2016 British Broadcasting Corporation.
This software is provided by Lancaster University by arrangement with the BBC.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.


Using the BBC MicroBit.
This program shows the Temperature which can be adjusted up or down to reflect true ambient temperature using B (down) and A (up).
Pressing A+B together changes mode from temperature to compass text heading display to compass heading graphic. Pressing A+B will circle around the three
modes.
Touching pins GND and P0 dims display, GND and P1 brightens display. GND and P2 shows actual device temperature.

developed by daw9000. no copywrite, free for whatever...
*/
#include "MicroBit.h"


MicroBit uBit;
int  xx;
int mode=0;
// array of compass headings upper and lower for each point displayed
int compassH[16][2]={
    {351,12},{13,33},{34,55},{56,78},{79,100},{101,123},{124,146},{147,169},{170,192},
    {193,215},{216,237},{238,259},{260,282},{283,305},{306,328},{329,350}
};
// array of compass points display led coordinates
int compassLed[16][3][2]={
    {{2,2},{2,1},{2,0}},
    {{2,2},{3,1},{3,0}},
    {{2,2},{3,1},{4,0}},
    {{2,2},{3,2},{4,1}},
    {{2,2},{3,2},{4,2}},
    {{2,2},{3,2},{4,3}},
    {{2,2},{3,3},{4,4}},
    {{2,2},{3,3},{3,4}},
    {{2,2},{2,3},{2,4}},
    {{2,2},{1,3},{1,4}},
    {{2,2},{1,3},{0,4}},
    {{2,2},{1,3},{0,3}},
    {{2,2},{1,2},{0,2}},
    {{2,2},{1,3},{0,1}},
    {{2,2},{1,1},{0,0}},
    {{2,2},{1,1},{1,0}},
    };
struct compassRef
{
    MicroBitImage xImage;
    int offsetX;
    int offsetY;
    };
    
MicroBitImage mImage;
    //offsetX=2; offsetY=0;
    MicroBitImage N("255,0,0\n,255,0,0\n,255,0,0\n");
    MicroBitImage NNE("0,255,0\n,0,255,0\n,255,0,0\n");
    MicroBitImage NE("0,0,255\n,0,255,0\n,255,0,0\n");
    MicroBitImage ENE("0,0,0\n,0,255,255\n,255,0,0\n");
    MicroBitImage E("0,0,0\n0,0,0\n,255,255,255\n");
    //offsetX=2; offsetY=2;
    MicroBitImage ESE("255,0,0\n,0,255,255\n,0,0,0\n");
    MicroBitImage SE("255,0,0\n,0,255,0\n,0,0,255\n");
    MicroBitImage SSE("255,0,0\n,0,255,255\n,0,0,0\n");
    MicroBitImage S("255,0,0\n,255,0,0\n,255,0,0\n");
    //offsetX=0; offsetY=2;
    MicroBitImage SSW("0,0,255\n,0,255,0\n,0,255,0\n");
    MicroBitImage SW("0,0,255\n,0,255,0\n,255,0,0\n");
    MicroBitImage WSW("0,0,255\n,255,255,0\n,0,0,0\n");
    MicroBitImage W("255,255,255\n,0,0,0\n,0,0,0\n");
    //offsetX=0; offsetY=0;
    MicroBitImage WNW("0,0,0\n,255,255,0\n,0,0,255\n");
    MicroBitImage NW("255,0,0\n,0,255,0\n,0,0,255\n");
    MicroBitImage NWN("0,255,0\n,0,255,0\n,0,0,255\n");
    

void onButton(MicroBitEvent e)
    {
        if (e.source == MICROBIT_ID_BUTTON_A and e.value == MICROBIT_BUTTON_EVT_CLICK)
        {
                if (mode==0){
                xx++;}
         }
         
        if (e.source == MICROBIT_ID_BUTTON_B and e.value == MICROBIT_BUTTON_EVT_CLICK)
        {
            if (mode==0){
            xx--;}
        }
        
        if (e.source == MICROBIT_ID_BUTTON_A and e.value == MICROBIT_BUTTON_EVT_LONG_CLICK)
        {
          
         }
         
         if (e.source == MICROBIT_ID_BUTTON_B and e.value == MICROBIT_BUTTON_EVT_LONG_CLICK)
         {
        }
    
    if (e.source == MICROBIT_ID_BUTTON_AB and  e.value == MICROBIT_BUTTON_EVT_CLICK)
       { 
        mode++;
        if (mode>2)
        {
            mode=0;
            uBit.sleep(100);
        }
       }
       
    if (e.source == MICROBIT_ID_IO_P0)
    {
    if (uBit.io.P0.isTouched())
    {
            if (uBit.display.getBrightness() > 25) 
            {
                uBit.display.setBrightness(uBit.display.getBrightness()-100);
            }
            else{
                uBit.display.setBrightness(5);
                }
                uBit.sleep(100);
                
        }
                
        }
        
    if (e.source == MICROBIT_ID_IO_P1)
    {
         
    if (uBit.io.P1.isTouched())
    {
        if (uBit.display.getBrightness()<225)
            {
               uBit.display.setBrightness(uBit.display.getBrightness()+100);
            }
            else
            {
                 uBit.display.setBrightness(255);
            }
            uBit.sleep(100);
            
        }
        }
       

    if (e.source == MICROBIT_ID_IO_P2)
    {
          
    if (uBit.io.P2.isTouched())
    {
         uBit.display.scroll("DevTemp=");
   
        uBit.display.scroll( uBit.thermometer.getTemperature());
        uBit.sleep(100);
        }
        
        }
    }
compassRef compassPoints(int compassHeading)
{

    
    int h;
    compassRef mcompassRef;
         
         h=compassHeading;
        // special case for 351 -> 12 deg N
        if (h <= 12){mcompassRef.xImage=N; mcompassRef.offsetX = 2; mcompassRef.offsetY=0;} 
        if (h >=351 and h<=360){mcompassRef.xImage=N;mcompassRef.offsetX = 2; mcompassRef.offsetY=0;}
        if (h >=compassH[1][0] and h<=compassH[1][1]) {mcompassRef.xImage=NNE; mcompassRef.offsetX = 2; mcompassRef.offsetY=0;}
        if (h >= compassH[2][0] and h<=compassH[2][1]) {mcompassRef.xImage=NE; mcompassRef.offsetX = 2; mcompassRef.offsetY=0;}
        if (h >= compassH[3][0] and h<=compassH[3][1]) {mcompassRef.xImage=ENE;mcompassRef.offsetX=2; mcompassRef.offsetY=0;}
        if (h>=compassH[4][0] and h<=compassH[4][1]) {mcompassRef.xImage=E;mcompassRef.offsetX=2; mcompassRef.offsetY=0;}
        if (h>=compassH[5][0] and h<=compassH[5][1]) {mcompassRef.xImage=ESE;mcompassRef.offsetX=2; mcompassRef.offsetY=2;}
        if (h>=compassH[6][0] and h<=compassH[6][1]) {mcompassRef.xImage=SE;mcompassRef.offsetX=2; mcompassRef.offsetY=2;}
        if (h>=compassH[7][0] and h<=compassH[7][1]) {mcompassRef.xImage=SSE;mcompassRef.offsetX=2; mcompassRef.offsetY=2;}
        if (h>=compassH[8][0] and h<=compassH[8][1]) {mcompassRef.xImage=S;mcompassRef.offsetX=2; mcompassRef.offsetY=2;}
        if (h>=compassH[9][0] and h<=compassH[9][1]) {mcompassRef.xImage=SSW;mcompassRef.offsetX=0; mcompassRef.offsetY=2;}
        if (h>=compassH[10][0] and h<=compassH[10][1]) {mcompassRef.xImage=SW;mcompassRef.offsetX=0; mcompassRef.offsetY=2;}
        if (h>=compassH[11][0] and h<=compassH[11][1]) {mcompassRef.xImage=WSW;mcompassRef.offsetX=0; mcompassRef.offsetY=2;}
        if (h>=compassH[12][0] and h<=compassH[12][1]) {mcompassRef.xImage=W;mcompassRef.offsetX=0; mcompassRef.offsetY=2;}
        if (h>=compassH[13][0] and h<=compassH[13][1]) {mcompassRef.xImage=WNW;mcompassRef.offsetX=0; mcompassRef.offsetY=0;}
        if (h>=compassH[14][0] and h<=compassH[14][1]) {mcompassRef.xImage=NW;mcompassRef.offsetX=0; mcompassRef.offsetY=0;}
        if (h>=compassH[15][0] and h<=compassH[15][1]) {mcompassRef.xImage=NWN;mcompassRef.offsetX=0; mcompassRef.offsetY=0;}
        
        return mcompassRef;
}
        
int main(void)
{
    // Initialise the micro:bit runtime.
        uBit.init();
     // Register to receive events when any buttons are clicked, including the A+B virtual button (both buttons at once).
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_A, MICROBIT_EVT_ANY, onButton);
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_B, MICROBIT_EVT_ANY, onButton);
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_AB, MICROBIT_EVT_ANY, onButton);
     // Also register for touch events on P0, P1 and P2.
    uBit.messageBus.listen(MICROBIT_ID_IO_P0, MICROBIT_EVT_ANY, onButton);
    uBit.messageBus.listen(MICROBIT_ID_IO_P1, MICROBIT_EVT_ANY, onButton);
    uBit.messageBus.listen(MICROBIT_ID_IO_P2, MICROBIT_EVT_ANY, onButton);

    // Put the P0, P1 and P2 pins into touch sense mode.
     
    uBit.io.P0.isTouched();
    uBit.io.P1.isTouched();
    uBit.io.P2.isTouched();

    while (true)
    {
    if ( (not(uBit.io.P0.isTouched())) and (not(uBit.io.P1.isTouched())) and (not (uBit.io.P2.isTouched())) )
      {
      if (mode==0)
      {
        uBit.display.scroll("Temp=");
   
        uBit.display.scroll( uBit.thermometer.getTemperature() + xx);
        uBit.sleep(100);
      }
      if (mode==1)
      {
        uBit.display.scroll("Hdg:");
        uBit.display.scroll(uBit.compass.heading());
        uBit.sleep(100);
      }
      if (mode==2)
      {
        uBit.display.clear();
        compassRef myCompass;
        int hdg = uBit.compass.heading();
        myCompass = compassPoints(hdg);
        mImage = myCompass.xImage;
        int offsetX = myCompass.offsetX;
        int offsetY = myCompass.offsetY;
        uBit.display.print(mImage,offsetX,offsetY);
        uBit.sleep(100);
      
        
       }
    

    }
  }
    // If main exits, there may still be other fibers running or registered event handlers etc.
    // Simply release this fiber, which will mean we enter the scheduler. Worse case, we then
    // sit in the idle task forever, in a power efficient sleep.
    release_fiber();

}