/*
The MIT License (MIT)

Copyright (c) 2016 British Broadcasting Corporation.
This software is provided by Lancaster University by arrangement with the BBC.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#include "MicroBit.h"


MicroBit uBit;
int xx=0, mode=0;
//
// Scales the given value that is in the -1024 to 1024 range
// int a value between 0 and 4.
//
int pixel_from_g(int value)
{
    int x = 0;

    if (value > -750)
        x++;
    if (value > -250)
        x++;
    if (value > 250)
        x++;
    if (value > 750)
        x++;

    return x;
}

void onButton(MicroBitEvent e)
    {
        if (e.source == MICROBIT_ID_BUTTON_A and e.value == MICROBIT_BUTTON_EVT_CLICK)
        {
                if (mode==0){
                xx++;}
         }
         
        if (e.source == MICROBIT_ID_BUTTON_B and e.value == MICROBIT_BUTTON_EVT_CLICK)
        {
            if (mode==0){
            xx--;}
        }
        
        if (e.source == MICROBIT_ID_BUTTON_A and e.value == MICROBIT_BUTTON_EVT_LONG_CLICK)
        {
          
         }
         
         if (e.source == MICROBIT_ID_BUTTON_B and e.value == MICROBIT_BUTTON_EVT_LONG_CLICK)
         {
        }
    
    if (e.source == MICROBIT_ID_BUTTON_AB and  e.value == MICROBIT_BUTTON_EVT_CLICK)
       { 
        mode++;
        if (mode>2)
        {
            mode=0;
            uBit.sleep(100);
        }
       }
       
    if (e.source == MICROBIT_ID_IO_P0)
    {
    if (uBit.io.P0.isTouched())
    {
            if (uBit.display.getBrightness() > 25) 
            {
                uBit.display.setBrightness(uBit.display.getBrightness()-100);
            }
            else{
                uBit.display.setBrightness(5);
                }
                uBit.sleep(100);
                
        }
                
        }
        
    if (e.source == MICROBIT_ID_IO_P1)
    {
         
    if (uBit.io.P1.isTouched())
    {
        if (uBit.display.getBrightness()<225)
            {
               uBit.display.setBrightness(uBit.display.getBrightness()+100);
            }
            else
            {
                 uBit.display.setBrightness(255);
            }
            uBit.sleep(100);
            
        }
        }
       

    if (e.source == MICROBIT_ID_IO_P2)
    {
          
    if (uBit.io.P2.isTouched())
    {
         uBit.display.scroll("DevTemp=");
   
        uBit.display.scroll( uBit.thermometer.getTemperature());
        uBit.sleep(100);
        }
        
        }
    }
int main(void)
{
    // Initialise the micro:bit runtime.
        uBit.init();
     // Register to receive events when any buttons are clicked, including the A+B virtual button (both buttons at once).
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_A, MICROBIT_EVT_ANY, onButton);
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_B, MICROBIT_EVT_ANY, onButton);
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_AB, MICROBIT_EVT_ANY, onButton);
     // Also register for touch events on P0, P1 and P2.
    uBit.messageBus.listen(MICROBIT_ID_IO_P0, MICROBIT_EVT_ANY, onButton);
    uBit.messageBus.listen(MICROBIT_ID_IO_P1, MICROBIT_EVT_ANY, onButton);
    uBit.messageBus.listen(MICROBIT_ID_IO_P2, MICROBIT_EVT_ANY, onButton);

    // Put the P0, P1 and P2 pins into touch sense mode.
     
    uBit.io.P0.isTouched();
    uBit.io.P1.isTouched();
    uBit.io.P2.isTouched();

    while (true){
    if ( (not(uBit.io.P0.isTouched())) and (not(uBit.io.P1.isTouched())) and (not (uBit.io.P2.isTouched())) )
    {
    if (mode==0)
    {
        uBit.display.scroll("Temp=");
   
        uBit.display.scroll( uBit.thermometer.getTemperature() + xx);
        uBit.sleep(100);
        }
    if (mode==1)
    {
        int x = pixel_from_g(uBit.accelerometer.getX());
        int y = pixel_from_g(uBit.accelerometer.getY());

        uBit.display.image.clear();
        uBit.display.image.setPixelValue(x, y, 255);
        
        uBit.sleep(100);
        }
    if (mode==2)
    {
        uBit.display.scroll("Hdg:");
        uBit.display.scroll(uBit.compass.heading());
        uBit.sleep(100);
    }
    
    
    }

    uBit.sleep(200);
    
    }
    

    

    // If main exits, there may still be other fibers running or registered event handlers etc.
    // Simply release this fiber, which will mean we enter the scheduler. Worse case, we then
    // sit in the idle task forever, in a power efficient sleep.
    release_fiber();
}


