#include "mbed.h"
#include "TextLCD.h"
//#include "PID.h"
#define RATE 0.1

Ticker tick;
AnalogIn pv(A0);
PwmOut co(PTE21);
DigitalIn PVMAS(PTC13);
DigitalIn PVMENOS(PTC12);
TextLCD lcd(D11,D10,D9,D5,D4,D3,D2);
DigitalOut led2(LED_GREEN);

float SP = 0.7;
float val;
float M, MA, C; //muestra , muestra anterior y control
float P, I, D;
float a = 15, b = 13 ; 
float tempCi, tempCo;

void visualizacion(){
    
    tempCi=(pv.read()*3.685503686*100);
    tempCo=((SP/5.00)*3.685503686*100);
    
    lcd.gotoxy(1,1);
    lcd.printf("PV = %2.2f C       ",tempCi);
    lcd.gotoxy(1,2);
    lcd.printf("SP = %2.2f C       ",tempCo);
        
    if(PVMAS==1){
        SP += 0.01;
        //controller.setSetPoint(SP);
    }
    if(PVMENOS==1){
        SP -= 0.01;
        //controller.setSetPoint(SP);
    }
    wait(RATE);
}

void control() {
    
    led2 = !led2;
    val = pv.read()*5.00;
    
    if(SP >= val){
           
        M = val; 
        P = a*M;
        D = MA + b*M;
        I = P + a*M;
        MA = M;
        C = P + I + D;
        C = C/5.00;
        co = C;
        
    }else{
        //co = 0;
        M = val; 
        P = a*M;
        D = MA + b*M;
        I = P + a*M;
        MA = M;
        C = P + I + D;
        C = C/5.00;
        co = -C;
    }       
}

int main(){

  tick.attach(&control, 0.1); // setup ticker to call flip led2 after 0.7 seconds
  lcd.gotoxy(1,1);
  lcd.printf("CONTROL PID");
  lcd.gotoxy(1,2);
  lcd.printf("PLANTA TERMICA");
  wait(1.5);
  lcd.gotoxy(1,1);
  lcd.printf("");
  lcd.printf("MARISOL             ");
  lcd.gotoxy(1,2);
  lcd.printf("MESA                ");
  wait(1.5);
    
  while(1){
    
    visualizacion();  
    
  }

}
