#ifndef _DebugPort
#define _DebugPort
#include "mbed.h"

class DebugPort {
    protected:
        //Serial m_pc(USBTX, USBRX);
        Serial* m_pc;
        DigitalOut* led_red;
        DigitalOut* led_green;
        DigitalOut* led_blue;
        
        int m_level;
        
    public:
        void setLED(bool r, bool g, bool b) {    
            *led_red = !r;
            *led_green = !g;
            *led_blue = !b;
        }
        
        DebugPort() {
            m_level = 0;
            
            m_pc = new Serial(USBTX,USBRX);
            led_red = new DigitalOut(LED_RED);
            led_green = new DigitalOut(LED_GREEN);
            led_blue = new DigitalOut(LED_BLUE);
        
            m_pc->baud(115200);
            m_pc->format(8,SerialBase::None,1);
            setbuf(*m_pc,NULL);  // turn off buffering of printf output
            setLED(0,0,0);
        }
        ~DebugPort() {
            delete led_red;
            delete led_green;
            delete led_blue;
            delete m_pc;
        }
        void send(const char* msg, int level=0) {
            m_pc->printf(msg);
            m_level=level;
            if(m_level>0) {  // major fail.  stop processing and toggle led
                for(int i =0; i<10; ++i) {
                    setLED(0,0,0);
                    wait(0.1);
                    setLED(1,0,0);
                    wait(0.1);
                }
            }
        }
        
        int level() {
            int ret=m_level;
            m_level=0;
            return ret;
        }
       
};
    
#endif