#ifndef _AQUOSTV
#define _AQUOSTV
#include "mbed.h"
#include <string.h>
#include <stdio.h>

#include "DebugPort.h"

const char gblHelp[] = "                                                   \n\
poweron                   Power on SharpAquos                              \n\
poweroff                  Power off SharpAquos                             \n\
volume##                  Set volume to two digit number                   \n\
input#                    Set input to one digit number                    \n\
selecttv                  Set input to tv                                  \n\
chanalog                  Set TV channel to analog 1-136                   \n\
chdigiair####             Set TV to digital air 1-9999                     \n\
chdigicable####.####      Set TV to digital cable with major.minor         \n\
chdigi2cable#####         Set TV to digital cable with 0-63839999          \n\
chup                      TV Channel Up                                    \n\
chdw                      TV Channel Down                                  \n\
";


#define AQUOSBUF 128

class AquosTV {
    private:
        const static unsigned int BUF_SIZE = 256;
        DebugPort *m_dbg;
        
    protected:
        Serial* m_tv;
        char httpcmd[128];
        char rs232cmd[128];
        
        void init();
        
        int getNumber(char** input, const char eol='\0');
        bool sendcmd(const char* cmd);
        
    public:
        AquosTV(DebugPort *dbg);
        virtual ~AquosTV();
        
        bool processCommand(const char* httpin);
        const char* http() ;
        const char* tvcmd() ;
};
    

#endif