#include "AquosTV.h"

AquosTV::AquosTV(DebugPort* dbg) {
    m_dbg = dbg;
    init();
}

AquosTV::~AquosTV() {
    delete m_tv;
}

void AquosTV::init() {
    m_tv = new Serial(PTC17,PTC16);
    m_tv->baud(9600);
    m_tv->format(8,SerialBase::None,1);
    //m_tv->set_flow_control(SerialBase::Disabled);
    memset(httpcmd,0,sizeof(char)*BUF_SIZE);
    memset(rs232cmd,0,sizeof(char)*BUF_SIZE);
    m_tv->printf("RSPW1   \r");  //--- enable rs232 commands for power on/off
}

bool AquosTV::sendcmd(const char* cmd) {
    bool ret=false;
    char status[5];
    int i = 0;
    m_dbg->send("\n\rSending TV Command:  ");
    m_dbg->send(cmd);
    m_dbg->send("\n");
    m_tv->printf(cmd);
    wait(0.05);
    
    ret=true;
    /*
    for(i=0;i<5;++i) status[i]='\0';
    for(i=0; !ret && i<5; ++i) {
        status[i] = m_tv->getc();
        ret = (status[i]=='\r');
    }
    ret = (strncmp(status,"OK",2)==0);
    */
    if(ret) m_dbg->send("Command Received 'OK' Status\n\r");
    else m_dbg->send("Command did NOT receive 'OK' Status -- Error condition\n\r");
    return ret;
}

int AquosTV::getNumber(char** input, const char eol) {
    int ret=0;
    for(;**input!=eol;++(*input)) {
        ret*=10;
        ret+=**input-'0';
    }
    ++(*input);
    return ret;
}
        
bool AquosTV::processCommand(const char* httpin) {
    int i;
    int j;
    char* p;
    bool ret=false;
    
    char request[BUF_SIZE];
    strncpy(httpcmd,httpin,BUF_SIZE-1);
    httpcmd[AQUOSBUF-1] = '\0';
    rs232cmd[0]='\0';
    if(strncmp(httpcmd,"GET /",5)==0) {
        for(i=5;httpcmd[i]!=' '&&httpcmd[i]!='\0'&&i<AQUOSBUF-1;++i) {
            request[i-5]=(httpcmd[i] | 0x20);  //make lower case
        }
        request[i-5]='\0';
        m_dbg->send("\n\rReceived Command Request:  ");
        m_dbg->send(request);
        m_dbg->send("\n\r");
            
        if(strncmp(request,"poweron",BUF_SIZE-1)==0) {
            strncpy(rs232cmd,"POWR1   \r",BUF_SIZE-1);
            ret = this->sendcmd(rs232cmd);
        }
        else if(strncmp(request,"poweroff",BUF_SIZE-1)==0) {
            strncpy(rs232cmd,"POWR0   \r",BUF_SIZE-1);
            ret = this->sendcmd(rs232cmd);
        }
        else if(strncmp(request,"selecttv",BUF_SIZE-1)==0) {
            strncpy(rs232cmd,"ITVD0   \r",BUF_SIZE-1);
            ret = this->sendcmd(rs232cmd);
        }
        else if(strncmp(request,"input",5)==0) {
            p=&(request[5]);
            i=getNumber(&p);
            if(i>0 && i<10) {
                snprintf(rs232cmd,BUF_SIZE-1,"IAVD%i   \r",i);
                ret = this->sendcmd(rs232cmd);
            }
        }
        else if(strncmp(request,"volume",6)==0) {
            p=&(request[6]);
            i=getNumber(&p);
            if(i>=0 && i<100) {
                snprintf(rs232cmd,BUF_SIZE-1,"VOLM%02i  \r",i);
                ret = this->sendcmd(rs232cmd);
            }
        }
        else if(strncmp(request,"chanalog",8)==0) {
            p=&(request[8]);
            i=getNumber(&p);
            if(i>0 && i<136) {
                snprintf(rs232cmd,BUF_SIZE-1,"DCCH%03i \r",i);
                ret = this->sendcmd(rs232cmd);
            }
        }
        
        else if(strncmp(request,"chdigiair",9)==0) {
            p=&(request[9]);
            i=getNumber(&p);
            if(i>0 && i<10000) {
                snprintf(rs232cmd,BUF_SIZE-1,"DA2P%04i\r",i);
                ret = this->sendcmd(rs232cmd);
            }
        }
        else if(strncmp(request,"chdigicable",11)==0) {
            p=&(request[11]);
            i=getNumber(&p,'.');
            if(i>0 && i<1000) {
                j=getNumber(&p);
                if(j>=0 && j<1000) {
                    snprintf(rs232cmd,BUF_SIZE-1,"DC2U%03i \r",i);
                    ret = this->sendcmd(rs232cmd);
                    wait(0.1);
                    snprintf(rs232cmd,BUF_SIZE-1,"DC2L%03i \r",j);
                    ret = this->sendcmd(rs232cmd);
                }
            }
        }
        else if(strncmp(request,"chdigi2cable",12)==0) {
            p=&(request[12]);
            i=getNumber(&p);
            if(i>0 && i<=63839999) {
                j=i%10000;
                i-=j;
                i/=10000;
                snprintf(rs232cmd,BUF_SIZE-1,"DC10%04i\r",j);
                ret = this
                ->sendcmd(rs232cmd);
                wait(0.1);
                snprintf(rs232cmd,BUF_SIZE-1,"DC11%04i\r",i);
                ret = this->sendcmd(rs232cmd);
            }
        }    
        else if(strncmp(request,"chup",4)==0) {
            snprintf(rs232cmd,BUF_SIZE-1,"CHUP1   \r");
            ret = this->sendcmd(rs232cmd);
        }
        else if(strncmp(request,"chdw",4)==0) {
            snprintf(rs232cmd,BUF_SIZE-1,"CHDW1   \r");
            ret = this->sendcmd(rs232cmd);
        }
        
        else {
            m_dbg->send("Unknown Command Request\n\r");
            ret = false;
        }
        
    }
    
    else {
        m_dbg->send("Improper Command Request\n\r");
        ret = false;
    }
    return ret;
}
        
const char* AquosTV::tvcmd()  { return rs232cmd; }
const char* AquosTV::http() { return httpcmd; }