 #include "AquosHTTP.h"
 
  
AquosHTTP::AquosHTTP(DebugPort *dbg, AquosTV* tv) { 
     m_dbg = dbg;
     m_tv = tv;
    init(); 
}

void AquosHTTP::arrayinit(char* ary) {
    memset(ary,0,sizeof(char)*BUF_SIZE);
}
void AquosHTTP::init() {
    arrayinit(m_buffer);
    arrayinit(m_response);
}

AquosHTTP::~AquosHTTP() { 
    m_eth.disconnect();
}

AquosHTTP& AquosHTTP::init(const char* ipaddr, const char* netmask, const char* gateway) {
    int ret;
    init();
    ret = m_eth.init(ipaddr,netmask,gateway);
    if(ret<0) { 
        m_dbg->send("EthernetInterface failed initialization",1);
    } else {
        m_dbg->send("EthernetInterface initialized:  ");
        m_dbg->send(m_eth.getIPAddress());
        m_dbg->send("\n\r");
    }
    
    ret = -1;
    while(ret<0) {
        wait(0.1);
        m_eth.connect(1000);  //usually fails, so no throw
        wait(0.1); 
        //m_server.set_blocking(true);
        ret = m_server.bind(80);
        if(ret<0) {
             m_dbg->send("Server failed to bind");
        } else {
            ret = m_server.listen(1);
            if(ret<0) m_dbg->send("Server failed to listen");
        }
    }
    return *this;
}
    
     
AquosHTTP& AquosHTTP::waitForRequest() {
    int n;
    int ret;
    ret = m_server.accept(m_client);
    if(ret<0) {
        m_dbg->send("Error accepting client request");
        return *this;
    }
    n = m_client.receive(m_buffer,BUF_SIZE-1);
    if(n>=BUF_SIZE-1) {
        m_dbg->send("Request exceeds buffer ... ignoring");
        return *this;
    }
    m_buffer[BUF_SIZE-1] = '\0';
    m_buffer[n] = '\0';
    return *this;
}

const char* AquosHTTP::getRequest() const {return m_buffer; }

int AquosHTTP::setResponse(const char* msg) {
    snprintf(m_response,BUF_SIZE-1,"<html><body>%s for:<br/><pre>%s</pre></body></html>\n",msg,m_buffer);
    return strlen(m_response);
}

AquosHTTP& AquosHTTP::returnSuccess() {
    int msglen = setResponse("SUCCESS!");
    char* buf = new char[msglen + 256];
    snprintf(buf,msglen+255,"HTTP/1.1 200 OK\r\nContent-Length: %i\r\nConnection: close\r\nContent-type: text/html\r\n\r\n%s",msglen,m_response);
    m_client.send(buf,strlen(buf));
    m_client.close(); 
    delete [] buf;
    return *this;
}



AquosHTTP& AquosHTTP::returnFailure() {
    int msglen = setResponse("FAILED!");
    char* buf = new char[msglen + 256];
    snprintf(buf,msglen+255,"HTTP/1.1 501 Not Implemented\r\nContent-Length: %i\r\nConnection: close\r\nContent-type: text/html\r\n\r\n%s",msglen,m_response);
    m_client.send(buf,strlen(buf));
    m_client.close(); 
    delete [] buf;
    return *this;
}

AquosHTTP& AquosHTTP::returnHelp() {
    int helplen = strlen(gblHelp);
    char* buf = new char[helplen+256];
    snprintf(buf,helplen+255,"HTTP/1.1 200 OK\r\nContent-Length: %i\r\nConnection: close\r\nContent-type: text/html\r\n\r\n%s",helplen,gblHelp);
    m_client.send(buf,strlen(buf));
    m_client.close();
    delete [] buf;
    return *this;
}