#include "mbed.h"
#include "EthernetInterface.h"
#include "rtos.h"
#include "DebugPort.h"
#include "AquosHTTP.h"
#include "AquosTV.h"
#include <string.h>

#define DBG 1

const char ip[] = "192.168.16.36";
const char mask[] = "255.255.255.0";
const char gateway[] = "192.168.16.1";

int main() {
    bool loop=true;
    DebugPort dbg;
    while(true) {
        loop=true;
        dbg.setLED(1,1,0); //yellow for init
        wait(0.1);
    
        AquosTV tv(&dbg);
        AquosHTTP server(&dbg,&tv);
        server.init(ip,mask,gateway);
    
        while(loop) {
            dbg.setLED(0,0,0); //off while waiting
            server.waitForRequest();
            dbg.setLED(0,0,1); //blue in progress
            if( strncmp(server.getRequest(),"GET /help",9)==0) {
                dbg.setLED(0,1,0);
                server.returnHelp();
            }              
            else {
                if( tv.processCommand( server.getRequest() )) {
                    dbg.setLED(0,1,0);
                    dbg.send("Command Success!\n\r");
                    server.returnSuccess();
                } 
                else {
                    dbg.setLED(1,0,0);
                    dbg.send("Command Fail!\n\r");
                    server.returnFailure();
                }
            }
            loop=(dbg.level()==0);
        }
    }
}
