#ifndef _AQUOSHTTP
#define _AQUOSHTTP

#include "EthernetInterface.h"
#include "rtos.h"
#include <string.h>
#include "DebugPort.h"
#include "AquosTV.h"

class AquosHTTP {
    private:
        const static unsigned int BUF_SIZE = 256;
        DebugPort* m_dbg;
        AquosTV* m_tv;
        
    protected:
        EthernetInterface m_eth;
        TCPSocketServer m_server;
        TCPSocketConnection m_client;
            
        char m_buffer[BUF_SIZE];
        char m_response[BUF_SIZE];
        
        void init();
        void arrayinit(char* ary);
        
        int setResponse(const char* msg);
        
    public:
        AquosHTTP(DebugPort* dbg, AquosTV* tv);
        ~AquosHTTP();
        
        AquosHTTP& init(const char *ipaddr, const char* netmask, const char* gateway);
        
        AquosHTTP& waitForRequest();
        const char* getRequest() const;
        
        AquosHTTP& returnSuccess();
        AquosHTTP& returnFailure();
        
        AquosHTTP& returnHelp();
};


#endif