#include "mbed.h"
#include "Adafruit_GFX.h"
#include "gamma.h"

#ifndef _LED_MATRIX_H
#define _LED_MATRIX_H

#define LOW 0
#define HIGH 1
#define PLANES 5
#define WIDTH 64
#define HEIGHT 32
#define HEIGHT_DEV_2 (HEIGHT / 2)

class LedMatrix : public Adafruit_GFX {

 private:       
    void WrRow(unsigned char Row);

    unsigned char gm[2][PLANES][HEIGHT_DEV_2][WIDTH];
    unsigned int plane;
    unsigned int currRow;
    unsigned int tickCount;
    char shownBuffer;
    char drawBuffer;
    bool refreshed;

 public:
    LedMatrix();
    void SetDoubleBuffer(bool setDoubleBuffer);
    void Init();
    void Swap(bool copyBuffer = false);
    void CopyBuffer(char oldBuffer, char newBuffer);
    uint16_t Color333(uint8_t r, uint8_t g, uint8_t b);
    uint16_t Color444(uint8_t r, uint8_t g, uint8_t b);
    uint16_t Color888(uint8_t r, uint8_t g, uint8_t b);
    uint16_t Color888(uint8_t r, uint8_t g, uint8_t b, bool gflag);
    uint16_t ColorHSV(long hue, uint8_t sat, uint8_t val, bool gflag);
    void drawPixel(int16_t x, int16_t y, uint16_t c);
    void Paint();
};

#endif