#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
//#include "stm32746g_discovery_ts.h"
#include "GigatronCPU.h"
#include "I2CConfig.h"
#include "WiiClassicControllerReader.h"


Serial serial(USBTX, USBRX);

#define BUTTON_A        0x80
#define BUTTON_B        0x40
#define BUTTON_SELECT   0x20
#define BUTTON_START    0x10
#define BUTTON_UP       0x08
#define BUTTON_DOWN     0x04
#define BUTTON_LEFT     0x02
#define BUTTON_RIGHT    0x01

#define HZ 6250000

GigatronCPU * cpu;
CPUStates cpuState;
VGA vga;
bool vSync = false;
uint32_t cycles = 0;
bool justStarted = true;
int ledStatus = 0;

extern const uint8_t rom_map[];

/*
void ReadAndReport(WiiClassicControllerReader* const ctrlr, const char* const portname)
{
    int bufSize = 0;
    char* bufPtr = NULL;
    bool debug = true;

    ctrlr->RequestRead();
    serial.printf("%s: ", portname);
        
    if (debug)
    {
        bufSize = ctrlr->getBufferSize();
        bufPtr = ctrlr->getReadBuf();
        if (bufPtr != NULL)
        {
            for (int i = 0; i < bufSize; i++)
            {
                serial.printf("%x ", bufPtr[i]);
            }
            serial.printf("\r\n");
        }
    }
    serial.printf("\r\nA\tB\tX\tY\tZL\tZR\tDU\tDD\tDL\tDR\tH\r\n");    
    serial.printf("%d\t", ctrlr->getButtonA());
    serial.printf("%d\t", ctrlr->getButtonB());
    serial.printf("%d\t", ctrlr->getButtonX());
    serial.printf("%d\t", ctrlr->getButtonY());
    serial.printf("%d\t", ctrlr->getButtonZL());
    serial.printf("%d\t", ctrlr->getButtonZR());
    serial.printf("%d\t", ctrlr->getButtonDU());
    serial.printf("%d\t", ctrlr->getButtonDD());
    serial.printf("%d\t", ctrlr->getButtonDL());
    serial.printf("%d\t", ctrlr->getButtonDR());
    serial.printf("%d\t", ctrlr->getButtonHOME());
    serial.printf("\r\nSEL\tSTART\tLT\tLC\tRT\tRC\tLX\tLY\tRX\tRY\r\n");
    serial.printf("%d\t", ctrlr->getButtonSELECT());
    serial.printf("%d\t", ctrlr->getButtonSTART());
    serial.printf("%d\t", ctrlr->getButtonLT());
    serial.printf("%d\t", ctrlr->getButtonLC());
    serial.printf("%d\t", ctrlr->getButtonRT());
    serial.printf("%d\t", ctrlr->getButtonRC());
    serial.printf("%d\t", ctrlr->getLJoyX());
    serial.printf("%d\t", ctrlr->getLJoyY());
    serial.printf("%d\t", ctrlr->getRJoyX());
    serial.printf("%d\t", ctrlr->getRJoyY());
    serial.printf("\r\n\n\n");
}
*/

int main()
{
    WiiClassicControllerReader ctrlrA(I2CPort_A::SDA, I2CPort_A::SCL);
    //I2C test(PB_9, PB_8);
    
    /*
    while (true)
    {
        ReadAndReport(&ctrlrA, "PORT A");                
        wait(1);
    }*/
    
    
    ctrlrA.RequestRead();
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    //BSP_LCD_LayerRgb565Init(1, 0xC0100000);     //0xC007F800 - End of Page 1
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    //BSP_LCD_SelectLayer(1);

    BSP_LCD_SetFont(&Font12);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    
    BSP_LCD_Clear(LCD_COLOR_BLACK);
    
    cpu = new GigatronCPU();    
    cpuState.Current = new CPUState;
    cpuState.New = new CPUState;
        
    cpu->SetCPURom((uint8_t *) &rom_map);
    
    while(1) {
        cpuState = cpu->CpuCycle(cpuState);
        cycles++;
        
        vga.ClockCycle(cpuState.New->OUT);  
        

        if ((cycles % ((HZ / 100) + 100)) == 0 && !justStarted)
        {
            int buttons = 0x00;
            
            ctrlrA.ControllerReadCmd();      
            //ctrlrA.RequestRead();
            ctrlrA.ControllerDecode();
                       
            if (ctrlrA.getButtonA() == 0)
            {
                buttons |= BUTTON_A;
                //serial.printf("A ");
            }
            
            if (ctrlrA.getButtonB() == 0)
            {
                buttons |= BUTTON_B;
                //serial.printf("B ");
            }
            
            if (ctrlrA.getButtonDD() == 0)
            {
                buttons |= BUTTON_DOWN;
                //serial.printf("D ");
            }
            
            if (ctrlrA.getButtonDU() == 0)
            {
                buttons |= BUTTON_UP;
                //serial.printf("U ");
            }
            
            if (ctrlrA.getButtonDL() == 0)
            {
                buttons |= BUTTON_LEFT;
                //serial.printf("U ");
            }
            
            if (ctrlrA.getButtonDR() == 0)
            {
                buttons |= BUTTON_RIGHT;
                //serial.printf("U ");
            }
            
            if (ctrlrA.getButtonSTART() == 0)
            {
                buttons |= BUTTON_START;
                //serial.printf("U ");
            }
            
            if (ctrlrA.getButtonSELECT() == 0)
            {
                buttons |= BUTTON_SELECT;
                //serial.printf("U ");
            }

            // Active Low
            cpuState.New->IN = buttons ^ 0xFF;
        } 
        else if ((cycles % (HZ / 100)) == 0)
        {
            ctrlrA.ControllerWriteCmd();
        }
        /*
        else if ((cycles % (HZ / 100)) == 0)
        {
            if (serial.readable() == 1) 
            {
                char c = serial.getc();
                
                serial.printf("%c", c);
                
                switch(c)
                {
                    case 13:
                        c = 10;
                        break;
                }               
                
                cpuState.New->IN = c;
            }
        }
        */
        
        justStarted = false;   
    }
}
