#if defined(TARGET_STM32F767ZI)

#include "mbed.h"
#include "pinmap.h"

typedef struct {
    DigitalInOut *_pin;
    uint32_t mask;
} fastio_vars;

#define PINMASK             (1 << STM_PIN(pin))
#define PINMASK_CLR         ((1<<16) << STM_PIN(pin))
#define PORT                ((GPIO_TypeDef *)(GPIOA_BASE + 0x0400 * STM_PORT(pin)))

#define INIT_PIN            this->container._pin = new DigitalInOut(pin); container.mask = PINMASK
#define DESTROY_PIN     

#define SET_DIR_INPUT       this->container._pin->input()
#define SET_DIR_OUTPUT      this->container._pin->output()
#define SET_MODE(pull)      this->container._pin->mode(pull)

#define WRITE_PIN_SET       (PORT->BSRR = PINMASK)
#define WRITE_PIN_CLR       (PORT->BSRR = PINMASK_CLR)

#define READ_PIN            ((PORT->IDR & container.mask) ? 1 : 0)

#endif
