#include "Arduino.h"

#include <MCUFRIEND_kbv.h>
MCUFRIEND_kbv tft;

Serial pc(SERIAL_TX, SERIAL_RX);

// Assign human-readable names to some common 16-bit color values:
#define BLACK   0x0000
#define BLUE    0x001F
#define RED     0xF800
#define GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0
#define WHITE   0xFFFF
#define GRAY    0x8410

uint16_t version = MCUFRIEND_KBV_H_;

void setup()
{
    uint16_t ID = tft.readID(); //
    pc.printf("\nI have run this on a NUCLEO-F072\n");
    pc.printf("Please run it on your NUCLEO-L152\n");
    pc.printf("Found ID = 0x%04X\n", ID);
    tft.begin(ID);
}

void loop()
{
    static uint8_t aspect = 0;
    const char *aspectname[] = {
        "PORTRAIT", "LANDSCAPE", "PORTRAIT_REV", "LANDSCAPE_REV"
    };
    const char *colorname[] = { "BLUE", "GREEN", "RED", "GRAY" };
    uint16_t colormask[] = { BLUE, GREEN, RED, GRAY };
    uint16_t ID = tft.readID(); //
    tft.setRotation(aspect);
    int width = tft.width();
    int height = tft.height();
    tft.fillScreen(colormask[aspect]);
    tft.drawRect(0, 0, width, height, WHITE);
    tft.drawRect(32, 32, width - 64, height - 64, WHITE);
    tft.setTextSize(2);
    tft.setTextColor(BLACK);
    tft.setCursor(40, 40);
    tft.print("ID=0x");
    tft.println(ID, HEX);
    if (ID == 0xD3D3) tft.print(" w/o");
    tft.setCursor(40, 70);
    tft.print(aspectname[aspect]);
    tft.setCursor(40, 100);
    tft.print(width);
    tft.print(" x ");
    tft.print(height);
    tft.setTextColor(WHITE);
    tft.setCursor(40, 130);
    tft.print(colorname[aspect]);
    tft.setCursor(40, 160);
    tft.setTextSize(1);
    tft.print("MCUFRIEND_KBV_H_ = ");
    tft.print(version);
    if (++aspect > 3) aspect = 0;
    delay(5000);
}

uint32_t millis(void)
{
    static Timer t;
    static int first = 1;
    if (first) first = 0, t.start();
    return t.read_ms();
}

uint32_t micros(void)
{
    static Timer t;
    static int first = 1;
    if (first) first = 0, t.start();
    return t.read_us();
}

void main(void)
{
    setup();
    while (1) {
        loop();
    }
}
