#ifndef ARDUINO_H
#define ARDUINO_H

// GLUE_STUFF: add any functionality to Arduino.h
// WProgram.h just calls Arduino.h
// avr/pgmspace, itoa, Print, WString all come from STM32
// it would be nice to put main_glue.cpp here

#include <mbed.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <math.h>

#include "avr/dtostrf.h"
#include "itoa.h"

#include "WString.h"          //for String
#include "HardwareSerial.h"   //for Serial hack

extern uint32_t SystemCoreClock;
#define F_CPU SystemCoreClock

#define delay(ms) wait_ms(ms)
#define __builtin_bswap16(x) ( ((x)<<8) | ((x)>>8) )
typedef uint8_t byte;

extern uint32_t micros(void);
extern uint32_t millis(void);
extern void setup(void);
extern void loop(void);

#endif
