#include "mbed.h"
#include "Servo.h"
#include "Gripper.h"

Gripper::Gripper(PinName pinServoGrab=pinServoGrabDefault,PinName pinServoTurn=pinServoTurnDefault):servoGrab(pinServoGrab),servoTurn(pinServoTurn)
{
    // Kalibrasi Range Servo (idealnya bisa dari 0-180 derajat), harus di tuning manual
    servoGrab.calibrate(0.00125,45.0);
    servoTurn.calibrate(0.00125,45.0);
    // Posisi Awal Servo
    servoGrab = 0;
    servoTurn = 0.5;
}

void Gripper::grabBoneka()
{
    for(int i=0; i<25; i++) {
        servoGrab = i/100.0;
        wait(0.01);
    }
}

void Gripper::releaseBoneka()
{
    for(int i=25; i>0; i--) {
        servoGrab = i/100.0;
        wait(0.01);
    }
    }

void Gripper::liftBoneka() {
        for(int i=80; i>50; i--) {
            servoTurn = i/100.0;
            wait(0.01);
        }
    }

void Gripper::downBoneka() {
        for(int i=50; i<80; i++) {
            servoTurn = i/100.0;
            wait(0.01);
        }
    }