#include "mbed.h"

#include "rtos.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"



uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;

FILE *wave_file;
double t = 0;
double signal[200];
Mutex lcd_mutex;
DigitalOut motor (p24);
DigitalOut valve (p25);
AnalogIn forceSensor (p15);
bool state = true;
double cur_data = 0.0;
double prev_data = 0.0;
int localMax[200];
int diff [200];
int index = 0;
int cur_diff;
int actual_diff;
double heartRate;
double high_pressure;
double low_pressure;
void thread1(void const *args)
{
    while(1) {
        cur_data = forceSensor;
    }

}
void thread2(void const *args)
{
    while(1) {
        if (cur_data >.8 && state ) {
            motor = 0;
            for (int i = 0; i<200; i++) {
                signal[i] = cur_data;
                Thread::wait(50);
                state = true;
            }
            for (int i = 2; i<198; i++) {
                if (signal[i-1]<signal[i] && signal[i]>signal[i+1]&&signal[i-2] <signal[i] && signal[i+2]< signal[i]) {
                    localMax[index] = i*10;
                    index ++;
                }

                valve = 0;
                state = false;
            }
            for (int i = 0; i< index; i++) {

                for (int j = 0; j< index; j++) {
                    cur_diff = localMax[j]-localMax[i];
                    if (cur_diff>500 && cur_diff <1500) {
                        actual_diff = cur_diff;
                        heartRate  = 60*1000/(actual_diff);
                        high_pressure = ((signal[i]-.799)+.8)*120/.8;
                        low_pressure =  ((signal[j]-.798) +.8)*80/.8;
                    }
                }
            }

        }
    }
}
void thread3(void const *args)
{
    while(1) {
        lcd_mutex.lock();
        uLCD.locate(0,1);
        uLCD.printf("Systolic: %.3f", high_pressure);
        uLCD.locate(0,3);
        uLCD.printf("Diastolic: %.3f", low_pressure);
        uLCD.locate(0,5);
        uLCD.printf("BPM: %.3f", heartRate);
        uLCD.locate(0,7);
        uLCD.printf("%3f",cur_data);
        lcd_mutex.unlock();
    }

}

int main()
{
    uLCD.cls();
    uLCD.baudrate(3000000);
    valve = 1;
    motor = 1;
    Thread t1(thread1); //start thread1
    Thread t2(thread2); //start thread2
    Thread t3(thread3); //start thread3
    while(1) {

    }
}
