/* Demo for mbed Library for FTDI FT800  Enbedded Video Engine "EVE"
Updated for FTDI FT810 driver and 800x480 display.
 * by Peter Drescher, DC2PD 2014
 * Released under the MIT License: http://mbed.org/license/mit */

#include "mbed.h"
#include "FT_Platform.h"



FT800 TFT(p5,p6,p7,p8,p9,p10); // the FT800 is connected to SPI 5-7, then we have CS, INT, PD
// global Vars
unsigned int r,b,g;

// function to convert hue , saturation and  value to RGB
// see http://en.wikipedia.org/wiki/HSL_and_HSV
void hsv2rgb(float H,float S, float V)
{
    float f,h,p,q,t;
    int i;
    if( S == 0.0) {
        r = V * 255;  
        g = V * 255;
        b = V * 255;
        return;
    }
    if(H > 480.0) H = 0.0;   // check values
    if(S > 1.0) S = 1.0; 
    if(S < 0.0) S = 0.0;
    if(V > 1.0) V = 1.0;
    if(V < 0.0) V = 0.0;
    
    h = H / 60.0;
    i = (int) h;
    f = h - i;
    p = V * (1.0 - S);
    q = V * (1.0 - (S * f));
    t = V * (1.0 - (S * (1.0 - f)));
 
    switch(i) {
        case 0:
            r = V * 255;  
            g = t * 255;
            b = p * 255;
            break;
        case 1:
            r = q * 255;
            g = V * 255;
            b = p * 255;
            break;
        case 2:
            r = p * 255;
            g = V * 255;
            b = t * 255;
            break;
        case 3:
            r = p * 255;
            g = q * 255;
            b = V * 255;
            break;
        case 4:
            r = t * 255;
            g = p * 255;
            b = V * 255;
            break;
        case 5:
        default:
            r = V * 255;
            g = p * 255;
            b = q * 255;
            break;
    }  
}


/***************************************************************************/
/* Show a Screen with Text for 5 seconds                                   */
/* A spinner shows the delay                                               */
/***************************************************************************/

ft_void_t Start_Screen(ft_char8_t *str)
{
    TFT.DLstart();                                         // start a new display command list
    TFT.DL(CLEAR_COLOR_RGB(255,255,255));      // set the clear color to white
    TFT.DL(CLEAR(1,1,1));                      // clear buffers -> color buffer,stencil buffer, tag buffer
    TFT.DL(COLOR_RGB(0x80,0x80,0x00));         // set current color
    TFT.Text((TFT.DispWidth/2), TFT.DispHeight/2, 31, OPT_CENTERX, str); // draw Text with font 31
    TFT.DL(COLOR_RGB(0xFF,0x00,0x00));         // change current color
    TFT.Spinner((TFT.DispWidth/2),TFT.DispHeight/4, 0,0);  // draw a animated spinner

    TFT.DL(DISPLAY());                         // Display the image
    TFT.Swap();                                            // Swap the current display list
    TFT.Flush_Co_Buffer();                                 // Download the command list into fifo

    TFT.WaitCmdfifo_empty();                               // Wait till coprocessor completes the operation
    TFT.Sleep(5000);                                       // Wait 5 s to show
}

// construct the screen and download it to the LCD
void screen_1(unsigned int color,unsigned int bright)
{
    TFT.DLstart();                         // start a new display command list
    TFT.DL(CLEAR(1,1,1));                  // clear buffers -> color buffer,stencil buffer, tag buffer
    TFT.DL(COLOR_RGB(0xff,0xff,0xff));     // set current color to white
    TFT.DL(TAG(1));                        // assign TAG value 1
    //TFT.FgColor(COLOR_RGB(0xff,0,0));      // forground color red
    TFT.Dial(249, 86, 55, 0, color);       // dial for color 
    TFT.DL(TAG(2));                        // assign TAG value 2
    //TFT.FgColor(COLOR_RGB(0,0xff,0));      // forground color green
    TFT.Slider(196, 215, 236, 21, 0, bright , 255);       // slider for brightness 
    TFT.DL(COLOR_RGB(0xff,0xff,0xff));     // set current color to white
    TFT.Text(22, 84, 30, 0, "Color");      // text Color
    TFT.Text(22, 208, 30, 0, "Brightness");// text Brightness
    
    TFT.DL(POINT_SIZE(100));               // color point around the dial 
    TFT.DL(BEGIN(FTPOINTS));                  
    TFT.DL(COLOR_RGB(0x0,0x0,0xff));       // color of next point 
    TFT.DL(VERTEX2II(183,47,0,0));         // set point x,y 
    TFT.DL(COLOR_RGB(0xff,0x0,0x0)); 
    TFT.DL(VERTEX2II(249,162,0,0));
    TFT.DL(COLOR_RGB(0xff,0x0,0xff)); 
    TFT.DL(VERTEX2II(183,123,0,0));
    TFT.DL(COLOR_RGB(0xff,0xff,0x0)); 
    TFT.DL(VERTEX2II(317,123,0,0));
    TFT.DL(COLOR_RGB(0x0,0xff,0xff)); 
    TFT.DL(VERTEX2II(249,11,0,0));
    TFT.DL(COLOR_RGB(0x0,0xff,0x00)); 
    TFT.DL(VERTEX2II(317,50,0,0));

    TFT.DL(SCISSOR_XY(10,10));             // define sub area starting at 10,10
    TFT.DL(SCISSOR_SIZE(50,50));           // size 50,50  
    hsv2rgb(color /65536.0 * 360,1.0,bright / 255.0);  // calculate rgb color from settings 
    TFT.DL(CLEAR_COLOR_RGB(r,b,g));        // set filling color to r,g,b
    TFT.DL(CLEAR(1,1,1));                  // fill the area  

    TFT.DL(SCISSOR_XY(500,10));             // define sub area starting at 10,10
    TFT.DL(SCISSOR_SIZE(200,200));           // size 200,200    
    hsv2rgb(color /65536.0 * 360,1.0,bright / 255.0);  // calculate rgb color from settings 
    TFT.DL(CLEAR_COLOR_RGB(r,b,g));        // set filling color to r,g,b
    TFT.DL(CLEAR(1,1,1));                  // fill the area  

    TFT.DL(SCISSOR_XY(500,210));             // define sub area starting at 10,10
    TFT.DL(SCISSOR_SIZE(200,200));           // size 200,200    
    hsv2rgb(color /65536.0 * 360,1.0,bright / 255.0);  // calculate rgb color from settings 
    TFT.DL(CLEAR_COLOR_RGB(r,b,g));        // set filling color to r,g,b
    TFT.DL(CLEAR(1,1,1));                  // fill the area  
    
    TFT.DL(DISPLAY());                     // Display the image
    TFT.Swap();                            // Swap the current display list
    TFT.Flush_Co_Buffer();                 // Download the command list into fifo
    TFT.WaitCmdfifo_empty();               // Wait till coprocessor completes the operation
}

int main()
{

    unsigned int color = 0,bright = 0;
    ft_uint32_t TrackRegisterVal = 0;              // touch track

    Start_Screen("RGB DEMO2 START");                // Show start screen
    TFT.Calibrate();                               // calibrate the touch screen

    /* Set the tracker for the dial -  define the Area for touching */
    TFT.Track(249, 86, 1, 1, 1);                   // Dial  - dimension 1,1 means rotary
    TFT.Track(179, 199, 277, 48, 2);               // Slider
    TFT.Flush_Co_Buffer();                         // Download the commands into fifo
    TFT.WaitCmdfifo_empty();                       // Wait till coprocessor completes the operation
    screen_1(color,bright);                        // paint screen

    /* the demo is updating the screen in a endless loop                                    */
    while(1) {
        ft_uint8_t tagval = 0;
        TrackRegisterVal = TFT.Rd32(REG_TRACKER);    // check if one of the two tracking fields is touched
        tagval = TrackRegisterVal & 0xff;
        if(0 != tagval) {                            // touch -> get new values
            if(1 == tagval) {                        // the dial touched
                color = TrackRegisterVal>>16;        // get the new value
            } else if(2 == tagval) {                 // the slider is touched
                bright = TrackRegisterVal>>16;       // get new slider value
                bright = bright * 255/65536;         // scale it down to 255
            }
            screen_1(color,bright);                  // paint new screen
            TFT.Sleep(10);                           // wait 10ms for next check
        }

    }  // end of display loop
}



