#include "mbed.h"
#include "GT511C3.hpp"
#include "N5110.h"
N5110 N5110(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);  
Serial serial(USBTX, USBRX);
DigitalOut myled(LED1);
GT511C3 GT511C3(PTC17,PTC16);

void Clock();
void EnrollFP1();
void EnrollFP2();
void EnrollFP3();
void EnrollFP4();
void EnrollFP5();
void EnrollFP6();
void EnrollFP7();
void EnrollFP8();
void EnrollFP9();
void IDSelect();
int clkcheck1;
int clkcheck2;
int clkcheck3;
int clkcheck4;
int clkcheck5;
int clkcheck6;
int clkcheck7;
int clkcheck8;
int clkcheck9;
int UserIDDetect;
int UserID;
int select;

int progress(int status,char *msg)
{
    serial.printf("%s",msg);
    return 0;
}

int main()
{
    clkcheck1 = 0;
    clkcheck2= 0;
    clkcheck3= 0;     
    clkcheck4= 0;
    clkcheck5= 0;
    clkcheck6= 0;
    clkcheck7= 0;
    clkcheck8= 0;
    clkcheck9= 0;
    serial.format(8,Serial::None,1);
    serial.baud(9600);
    GT511C3.Open(); //Initialise the Fingerprint Sensor
    N5110.init(); //Initialise the screen
    N5110.setContrast(0);
    N5110.normalMode();
    N5110.setBrightness(0); //Max Brightness
    N5110.printString("Biometric",1,1);
    N5110.printString("Smart",1,2);
    N5110.printString("Attendance",1,3);
    N5110.printString("System",1,4);
    N5110.refresh();
    wait(4);
    N5110.clear();
    N5110.printString("By",10,1);
    N5110.printString("David Bruce",1,2);
    N5110.printString("Loading",1,4);
    N5110.refresh();
    wait(0.25);
    N5110.printString("Loading.",1,4);
    N5110.refresh();
    wait(0.25);
    N5110.printString("Loading..",1,4);
    N5110.refresh();
    wait(0.25);
    N5110.printString("Loading...",1,4);
    N5110.refresh();
    wait(0.25);
    N5110.clear();
    N5110.printString("By",10,1);
    N5110.printString("David Bruce",1,2);
    N5110.printString("Loading.",1,4);
    N5110.refresh();
    wait(0.25);
    N5110.printString("Loading..",1,4);
    N5110.refresh();
    wait(0.25);
    N5110.clear();
    N5110.printString("Press'a' on",1,2); //works with any key, but a is not linked to anything later so stop confusion
    N5110.printString("the keyboard",1,3);
    N5110.printString("to continue",1,4);
    N5110.refresh();
    wait(0.25);
    N5110.clear();
    IDSelect();
    }
    
void IDSelect(){
        while(1){
    char c = serial.getc();
    N5110.clear();
    N5110.printString("Select ID:",1,0);
    N5110.printString("To do so",1,1);
    N5110.printString("select a no.",1,2);
    N5110.printString("from 1-9 on",1,3);
    N5110.printString("your keyboard. Use",1,4);
    N5110.printString("'e' to confirm",1,5);
    N5110.refresh();
    serial.printf("%s",select);
    
        if(c == '1') {
        N5110.clear();
        N5110.printString("Select ID:",1,0);
        N5110.printString("..... 1 .....",1,1);
        N5110.printString("Press the letter",1,4);
        N5110.printString("'e' to confirm",1,5);
        N5110.refresh();
        select = 1;
        }
        
        if(c == '2') {
        N5110.clear();
        N5110.printString("Select ID:",1,0);
        N5110.printString("..... 2 .....",1,1);
        N5110.printString("Press the letter",1,4);
        N5110.printString("'e' to confirm",1,5);
        N5110.refresh();
        select = 2;
        }
        
        if(c == '3') {
        N5110.clear();
        N5110.printString("Select ID:",1,0);
        N5110.printString("..... 3 .....",1,1);
        N5110.printString("Press the letter",1,4);
        N5110.printString("'e' to confirm",1,5);
        N5110.refresh();
        select = 3;
        }
        
        if(c == '4') {
        N5110.clear();
        N5110.printString("Select ID:",1,0);
        N5110.printString("..... 4 .....",1,1);
        N5110.printString("Press the letter",1,4);
        N5110.printString("'e' to confirm",1,5);
        N5110.refresh();
        select = 4;
        }
        
        if(c == '5') {
        N5110.clear();
        N5110.printString("Select ID:",1,0);
        N5110.printString("..... 5 .....",1,1);
        N5110.printString("Press the letter",1,4);
        N5110.printString("'e' to confirm",1,5);
        N5110.refresh();
        select = 5;
        }
        
        if(c == '6') {
        N5110.clear();
        N5110.printString("Select ID:",1,0);
        N5110.printString("..... 6 .....",1,1);
        N5110.printString("Press the letter",1,4);
        N5110.printString("'e' to confirm",1,5);
        N5110.refresh();
        select = 6;
        }
        
        if(c == '7') {
        N5110.clear();
        N5110.printString("Select ID:",1,0);
        N5110.printString("..... 7 .....",1,1);
        N5110.printString("Press the letter",1,4);
        N5110.printString("'e' to confirm",1,5);
        N5110.refresh();
        select = 7;
        }
        
        if(c == '8') {
        N5110.clear();
        N5110.printString("Select ID:",1,0);
        N5110.printString("..... 8 .....",1,1);
        N5110.printString("Press the letter",1,4);
        N5110.printString("'e' to confirm",1,5);
        N5110.refresh();
        select = 8;
        }
        
        if(c == '9') {
        N5110.clear();
        N5110.printString("Select ID:",1,0);
        N5110.printString("..... 9 .....",1,1);
        N5110.printString("Press the letter",1,4);
        N5110.printString("'e' to confirm",1,5);
        N5110.refresh();
        select = 9;
        }
        
        if((select == 1) && (c == 'e')) {
        N5110.clear();
        N5110.printString("ID Selected:",1,0);
        N5110.printString("..... 1.....",1,1);
        N5110.refresh();
        wait(4);
        EnrollFP1();
        }
        
        if((select == 2) && (c == 'e')) {
        N5110.clear();
        N5110.printString("ID Selected:",1,0);
        N5110.printString("..... 2 .....",1,1);
        N5110.refresh();
        wait(4);
        EnrollFP2();
        }
        
        if((select == 3) && (c == 'e')) {
        N5110.clear();
        N5110.printString("ID Selected:",1,0);
        N5110.printString("..... 3 .....",1,1);
        N5110.refresh();
        wait(4);
        EnrollFP3();
        }
        
         if((select == 4) && (c == 'e')) {
        N5110.clear();
        N5110.printString("ID Selected:",1,0);
        N5110.printString("..... 4 .....",1,1);
        N5110.refresh();
        wait(4);
        EnrollFP4();
        }
        
        if((select == 5) && (c == 'e')) {
        N5110.clear();
        N5110.printString("ID Selected:",1,0);
        N5110.printString("..... 5 .....",1,1);
        N5110.refresh();
        wait(4);
        EnrollFP5();
        }
        
        if((select == 6) && (c == 'e')) {
        N5110.clear();
        N5110.printString("ID Selected:",1,0);
        N5110.printString("..... 6 .....",1,1);
        N5110.refresh();
        wait(4);
        EnrollFP6();
        }
        
        if((select == 7) && (c == 'e')) {
        N5110.clear();
        N5110.printString("ID Selected:",1,0);
        N5110.printString("..... 7 .....",1,1);
        N5110.refresh();
        wait(4);
        EnrollFP7();
        }
        
        if((select == 8) && (c == 'e')) {
        N5110.clear();
        N5110.printString("ID Selected:",1,0);
        N5110.printString("..... 8 .....",1,1);
        N5110.refresh();
        wait(4);
        EnrollFP8();
        }
        
        if((select == 9) && (c == 'e')) {
        N5110.clear();
        N5110.printString("ID Selected:",1,0);
        N5110.printString("..... 9 .....",1,1);
        N5110.refresh();
        wait(4);
        EnrollFP9();
        }
}
}    

void EnrollFP1(){   

    if(1){
    int UserID = 1; // Need to get this value from keyboard
    if(GT511C3.CheckEnrolled(UserID) == 0) { //If the User has previously been enrolled
    if(GT511C3.DeleteID(UserID) == 0){};//Delete User ID
         }

    N5110.clear();  
    N5110.printString("Place your",1,0);
    N5110.printString("finger on the",1,1);
    N5110.printString("sensor and",1,2);
    N5110.printString("remove it. Do",1,3);
    N5110.printString("until it is",1,4);
    N5110.printString("enrolled",1,5); //Instructions       
    N5110.refresh();
    
    GT511C3.Enroll(UserID,progress); //Enroll User with UserID of 1

    if(GT511C3.CheckEnrolled(UserID) == 0) {
        N5110.clear();
        N5110.printString("Successfully",1,1);
        N5110.printString("Enrolled",1,2);
        N5110.refresh();
        wait(2); //If UserID is enrolled, print "Successfully Enrolled" on N5110 screen
          
    GT511C3.CmosLed(1);
    Clock(); //Run Clock() This is seperate due to it being triggered in two places in the "register once, rebootable" version. 
   }
   }
   }
    
void EnrollFP2(){   

    if(1){
    int UserID = 2;// Need to get this value from keyboard
    if(GT511C3.CheckEnrolled(UserID) == 0) { //If the User has previously been enrolled
    if(GT511C3.DeleteID(UserID) == 0){};//Delete User ID
         }

    N5110.clear();  
    N5110.printString("Place your",1,0);
    N5110.printString("finger on the",1,1);
    N5110.printString("sensor and",1,2);
    N5110.printString("remove it. Do",1,3);
    N5110.printString("until it is",1,4);
    N5110.printString("enrolled",1,5); //Instructions       
    N5110.refresh();
    
    GT511C3.Enroll(UserID,progress); //Enroll User with UserID of 1

    if(GT511C3.CheckEnrolled(UserID) == 0) {
        N5110.clear();
        N5110.printString("Successfully",1,1);
        N5110.printString("Enrolled",1,2);
        N5110.refresh();
        wait(2); //If UserID is enrolled, print "Successfully Enrolled" on N5110 screen
          
    GT511C3.CmosLed(1);
    Clock(); //Run Clock() This is seperate due to it being triggered in two places in the "register once, rebootable" version. 
   }
   }
   }
   
void EnrollFP3(){   

    if(1){
    int UserID = 3; // Need to get this value from keyboard
    if(GT511C3.CheckEnrolled(UserID) == 0) { //If the User has previously been enrolled
    if(GT511C3.DeleteID(UserID) == 0){};//Delete User ID
         }

    N5110.clear();  
    N5110.printString("Place your",1,0);
    N5110.printString("finger on the",1,1);
    N5110.printString("sensor and",1,2);
    N5110.printString("remove it. Do",1,3);
    N5110.printString("until it is",1,4);
    N5110.printString("enrolled",1,5); //Instructions       
    N5110.refresh();
    
    GT511C3.Enroll(UserID,progress); //Enroll User with UserID of 1

    if(GT511C3.CheckEnrolled(UserID) == 0) {
        N5110.clear();
        N5110.printString("Successfully",1,1);
        N5110.printString("Enrolled",1,2);
        N5110.refresh();
        wait(2); //If UserID is enrolled, print "Successfully Enrolled" on N5110 screen
          
    GT511C3.CmosLed(1);
    Clock(); //Run Clock() This is seperate due to it being triggered in two places in the "register once, rebootable" version. 
   }
   }
   }
   
void EnrollFP4(){   

    if(1){
    int UserID = 4; // Need to get this value from keyboard
    if(GT511C3.CheckEnrolled(UserID) == 0) { //If the User has previously been enrolled
    if(GT511C3.DeleteID(UserID) == 0){};//Delete User ID
         }

    N5110.clear();  
    N5110.printString("Place your",1,0);
    N5110.printString("finger on the",1,1);
    N5110.printString("sensor and",1,2);
    N5110.printString("remove it. Do",1,3);
    N5110.printString("until it is",1,4);
    N5110.printString("enrolled",1,5); //Instructions       
    N5110.refresh();
    
    GT511C3.Enroll(UserID,progress); //Enroll User with UserID of 1

    if(GT511C3.CheckEnrolled(UserID) == 0) {
        N5110.clear();
        N5110.printString("Successfully",1,1);
        N5110.printString("Enrolled",1,2);
        N5110.refresh();
        wait(2); //If UserID is enrolled, print "Successfully Enrolled" on N5110 screen
          
    GT511C3.CmosLed(1);
    Clock(); //Run Clock() This is seperate due to it being triggered in two places in the "register once, rebootable" version. 
   }
   }
   }
   
void EnrollFP5(){   

    if(1){
    int UserID = 5; // Need to get this value from keyboard
    if(GT511C3.CheckEnrolled(UserID) == 0) { //If the User has previously been enrolled
    if(GT511C3.DeleteID(UserID) == 0){};//Delete User ID
         }

    N5110.clear();  
    N5110.printString("Place your",1,0);
    N5110.printString("finger on the",1,1);
    N5110.printString("sensor and",1,2);
    N5110.printString("remove it. Do",1,3);
    N5110.printString("until it is",1,4);
    N5110.printString("enrolled",1,5); //Instructions       
    N5110.refresh();
    
    GT511C3.Enroll(UserID,progress); //Enroll User with UserID of 1

    if(GT511C3.CheckEnrolled(UserID) == 0) {
        N5110.clear();
        N5110.printString("Successfully",1,1);
        N5110.printString("Enrolled",1,2);
        N5110.refresh();
        wait(2); //If UserID is enrolled, print "Successfully Enrolled" on N5110 screen
          
    GT511C3.CmosLed(1);
    Clock(); //Run Clock() This is seperate due to it being triggered in two places in the "register once, rebootable" version. 
   }
   }
   }
   
void EnrollFP6(){   

    if(1){
    int UserID = 6; // Need to get this value from keyboard
    if(GT511C3.CheckEnrolled(UserID) == 0) { //If the User has previously been enrolled
    if(GT511C3.DeleteID(UserID) == 0){};//Delete User ID
         }

    N5110.clear();  
    N5110.printString("Place your",1,0);
    N5110.printString("finger on the",1,1);
    N5110.printString("sensor and",1,2);
    N5110.printString("remove it. Do",1,3);
    N5110.printString("until it is",1,4);
    N5110.printString("enrolled",1,5); //Instructions       
    N5110.refresh();
    
    GT511C3.Enroll(UserID,progress); //Enroll User with UserID of 1

    if(GT511C3.CheckEnrolled(UserID) == 0) {
        N5110.clear();
        N5110.printString("Successfully",1,1);
        N5110.printString("Enrolled",1,2);
        N5110.refresh();
        wait(2); //If UserID is enrolled, print "Successfully Enrolled" on N5110 screen
          
    GT511C3.CmosLed(1);
    Clock(); //Run Clock() This is seperate due to it being triggered in two places in the "register once, rebootable" version. 
   }
   }
   }
   
void EnrollFP7(){   

    if(1){
    int UserID = 7; // Need to get this value from keyboard
    if(GT511C3.CheckEnrolled(UserID) == 0) { //If the User has previously been enrolled
    if(GT511C3.DeleteID(UserID) == 0){};//Delete User ID
         }

    N5110.clear();  
    N5110.printString("Place your",1,0);
    N5110.printString("finger on the",1,1);
    N5110.printString("sensor and",1,2);
    N5110.printString("remove it. Do",1,3);
    N5110.printString("until it is",1,4);
    N5110.printString("enrolled",1,5); //Instructions       
    N5110.refresh();
    
    GT511C3.Enroll(UserID,progress); //Enroll User with UserID of 1

    if(GT511C3.CheckEnrolled(UserID) == 0) {
        N5110.clear();
        N5110.printString("Successfully",1,1);
        N5110.printString("Enrolled",1,2);
        N5110.refresh();
        wait(2); //If UserID is enrolled, print "Successfully Enrolled" on N5110 screen
          
    GT511C3.CmosLed(1);
    Clock(); //Run Clock() This is seperate due to it being triggered in two places in the "register once, rebootable" version. 
   }
   }
   }
   
void EnrollFP8(){   

    if(1){
    int UserID = 8; // Need to get this value from keyboard
    if(GT511C3.CheckEnrolled(UserID) == 0) { //If the User has previously been enrolled
    if(GT511C3.DeleteID(UserID) == 0){};//Delete User ID
         }

    N5110.clear();  
    N5110.printString("Place your",1,0);
    N5110.printString("finger on the",1,1);
    N5110.printString("sensor and",1,2);
    N5110.printString("remove it. Do",1,3);
    N5110.printString("until it is",1,4);
    N5110.printString("enrolled",1,5); //Instructions       
    N5110.refresh();
    
    GT511C3.Enroll(UserID,progress); //Enroll User with UserID of 1

    if(GT511C3.CheckEnrolled(UserID) == 0) {
        N5110.clear();
        N5110.printString("Successfully",1,1);
        N5110.printString("Enrolled",1,2);
        N5110.refresh();
        wait(2); //If UserID is enrolled, print "Successfully Enrolled" on N5110 screen
          
    GT511C3.CmosLed(1);
    Clock(); //Run Clock() This is seperate due to it being triggered in two places in the "register once, rebootable" version. 
   }
   }
   }
   
void EnrollFP9(){   

    if(1){
    int UserID = 9; // Need to get this value from keyboard
    if(GT511C3.CheckEnrolled(UserID) == 0) { //If the User has previously been enrolled
    if(GT511C3.DeleteID(UserID) == 0){};//Delete User ID
         }

    N5110.clear();  
    N5110.printString("Place your",1,0);
    N5110.printString("finger on the",1,1);
    N5110.printString("sensor and",1,2);
    N5110.printString("remove it. Do",1,3);
    N5110.printString("until it is",1,4);
    N5110.printString("enrolled",1,5); //Instructions       
    N5110.refresh();
    
    GT511C3.Enroll(UserID,progress); //Enroll User with UserID of 1

    if(GT511C3.CheckEnrolled(UserID) == 0) {
        N5110.clear();
        N5110.printString("Successfully",1,1);
        N5110.printString("Enrolled",1,2);
        N5110.refresh();
        wait(2); //If UserID is enrolled, print "Successfully Enrolled" on N5110 screen
          
    GT511C3.CmosLed(1);
    Clock(); //Run Clock() This is seperate due to it being triggered in two places in the "register once, rebootable" version. 
   }
   }                         
   } 
   
void Clock(){ //This part of the code identifies the fingerprint, checks if it is enrolled and if so whether they are clocking in or clocking out
    while(1) {
        int reset = 0;
        N5110.clear();
        N5110.printString("Scan Finger to",1,2);
        N5110.printString("Clock In/Out",1,3);   
        N5110.refresh();
        
        
        GT511C3.WaitPress(1); //Code waits for a press
        if(GT511C3.Capture(1) != 0) continue; //Makes sure the scan of the fingerprint is a good one
        UserIDDetect = GT511C3.Identify(); //Detects the UserID of the press
        
            
        if (UserIDDetect ==-1) { //If -1, it is not registered
            N5110.clear();
            N5110.printString("Fingerprint",1,0);
            N5110.printString("Not Recognised",1,1);                    
            N5110.refresh();
            wait(3);
        };
        
        if ((UserIDDetect == 1) && (clkcheck1 == 0) && (reset == 0)){//If 1, it is the registered print, clkcheck 0 means the last action was a clock out
            N5110.clear();

            N5110.printString("User 1",1,1);
            N5110.printString("Clocked in",1,2);
            serial.printf("Clocked in" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:1");
            N5110.refresh();
            clkcheck1 = -1;
            reset = 1;//Clock in and out both require reset 0, and both change reset to 1 for 3 seconds to stop the code automaticlaly switching between both while UserIDDetect = 1
            wait(3);
        };
        
        
        if ((UserIDDetect == 1) && (clkcheck1 == -1) && (reset == 0)){
            N5110.clear();

            N5110.printString("User 1",1,1);
            N5110.printString("Clocked Out",1,2);
            serial.printf("Clocked Out" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:1");
            N5110.refresh();
            
            N5110.refresh();
            clkcheck1 = 0;
            reset = 1;
            wait(3);
        };
        
        if ((UserIDDetect == 2) && (clkcheck2 == 0) && (reset == 0)){//If 1, it is the registered print, clkcheck 0 means the last action was a clock out
            N5110.clear();

            N5110.printString("User 2",1,1);
            N5110.printString("Clocked in",1,2);
            serial.printf("Clocked in" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:2");
            N5110.refresh();
            clkcheck2 = -1;
            reset = 1;//Clock in and out both require reset 0, and both change reset to 1 for 3 seconds to stop the code automaticlaly switching between both while UserIDDetect = 1
            wait(3);
        };
        
        
        if ((UserIDDetect == 2) && (clkcheck2 == -1) && (reset == 0)){
            N5110.clear();

            N5110.printString("User 2",1,1);
            N5110.printString("Clocked Out",1,2);
            serial.printf("Clocked Out" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:2");
            N5110.refresh();
            
            N5110.refresh();
            clkcheck2 = 0;
            reset = 1;
            wait(3);
        };
        
        if ((UserIDDetect == 3) && (clkcheck3 == 0) && (reset == 0)){//If 1, it is the registered print, clkcheck 0 means the last action was a clock out
            N5110.clear();
            
            N5110.printString("User 3",1,1);
            N5110.printString("Clocked in",1,2);
            serial.printf("Clocked in" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:3");
            N5110.refresh();
            clkcheck3 = -1;
            reset = 1;//Clock in and out both require reset 0, and both change reset to 1 for 3 seconds to stop the code automaticlaly switching between both while UserIDDetect = 1
            wait(3);
        };
        
        
        if ((UserIDDetect == 3) && (clkcheck3 == -1) && (reset == 0)){
            N5110.clear();

            N5110.printString("User 3",1,1);
            N5110.printString("Clocked Out",1,2);
            serial.printf("Clocked Out" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:3");
            N5110.refresh();
            
            N5110.refresh();
            clkcheck3 = 0;
            reset = 1;
            wait(3);
        };
        
        if ((UserIDDetect == 4) && (clkcheck4 == 0) && (reset == 0)){//If 1, it is the registered print, clkcheck 0 means the last action was a clock out
            N5110.clear();

            N5110.printString("User 4",1,1);
            N5110.printString("Clocked in",1,2);
            serial.printf("Clocked in" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:4");
            N5110.refresh();
            clkcheck4 = -1;
            reset = 1;//Clock in and out both require reset 0, and both change reset to 1 for 3 seconds to stop the code automaticlaly switching between both while UserIDDetect = 1
            wait(3);
        };
        
        
        if ((UserIDDetect == 4) && (clkcheck4 == -1) && (reset == 0)){
            N5110.clear();

            N5110.printString("User 4",1,1);
            N5110.printString("Clocked Out",1,2);
            serial.printf("Clocked Out" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:4");
            N5110.refresh();
            
            N5110.refresh();
            clkcheck4 = 0;
            reset = 1;
            wait(3);
        };
        
        if ((UserIDDetect == 5) && (clkcheck5 == 0) && (reset == 0)){//If 1, it is the registered print, clkcheck 0 means the last action was a clock out
            N5110.clear();

            N5110.printString("User 5",1,1);
            N5110.printString("Clocked in",1,2);
            serial.printf("Clocked in" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:5");
            N5110.refresh();
            clkcheck5 = -1;
            reset = 1;//Clock in and out both require reset 0, and both change reset to 1 for 3 seconds to stop the code automaticlaly switching between both while UserIDDetect = 1
            wait(3);
        };
        
        
        if ((UserIDDetect == 5) && (clkcheck5 == -1) && (reset == 0)){
            N5110.clear();

            N5110.printString("User 5",1,1);
            N5110.printString("Clocked Out",1,2);
            serial.printf("Clocked Out" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:5");
            N5110.refresh();
            
            N5110.refresh();
            clkcheck5 = 0;
            reset = 1;
            wait(3);
        };
        
        if ((UserIDDetect == 6) && (clkcheck6 == 0) && (reset == 0)){//If 1, it is the registered print, clkcheck 0 means the last action was a clock out
            N5110.clear();

            N5110.printString("User 6",1,1);
            N5110.printString("Clocked in",1,2);
            serial.printf("Clocked in" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:6");
            N5110.refresh();
            clkcheck6 = -1;
            reset = 1;//Clock in and out both require reset 0, and both change reset to 1 for 3 seconds to stop the code automaticlaly switching between both while UserIDDetect = 1
            wait(3);
        };
        
        
        if ((UserIDDetect == 6) && (clkcheck6 == -1) && (reset == 0)){
            N5110.clear();

            N5110.printString("User 6",1,1);
            N5110.printString("Clocked Out",1,2);
            serial.printf("Clocked Out" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:6");
            N5110.refresh();
            
            N5110.refresh();
            clkcheck6 = 0;
            reset = 1;
            wait(3);
        };
        
        if ((UserIDDetect == 7) && (clkcheck7 == 0) && (reset == 0)){//If 1, it is the registered print, clkcheck 0 means the last action was a clock out
            N5110.clear();

            N5110.printString("User 7",1,1);
            N5110.printString("Clocked in",1,2);
            serial.printf("Clocked in" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:7");
            N5110.refresh();
            clkcheck7 = -1;
            reset = 1;//Clock in and out both require reset 0, and both change reset to 1 for 3 seconds to stop the code automaticlaly switching between both while UserIDDetect = 1
            wait(3);
        };
        
        
        if ((UserIDDetect == 7) && (clkcheck7 == -1) && (reset == 0)){
            N5110.clear();

            N5110.printString("User 7",1,1);
            N5110.printString("Clocked Out",1,2);
            serial.printf("Clocked Out" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:7");
            N5110.refresh();
            
            N5110.refresh();
            clkcheck7 = 0;
            reset = 1;
            wait(3);
        };
        
        if ((UserIDDetect == 8) && (clkcheck8 == 0) && (reset == 0)){//If 1, it is the registered print, clkcheck 0 means the last action was a clock out
            N5110.clear();

            N5110.printString("User 8",1,1);
            N5110.printString("Clocked in",1,2);
            serial.printf("Clocked in" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:8");
            N5110.refresh();
            clkcheck8 = -1;
            reset = 1;//Clock in and out both require reset 0, and both change reset to 1 for 3 seconds to stop the code automaticlaly switching between both while UserIDDetect = 1
            wait(3);
        };
        
        
        if ((UserIDDetect == 8) && (clkcheck8 == -1) && (reset == 0)){
            N5110.clear();

            N5110.printString("User 8",1,1);
            N5110.printString("Clocked Out",1,2);
            serial.printf("Clocked Out" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:8");
            N5110.refresh();
            
            N5110.refresh();
            clkcheck8 = 0;
            reset = 1;
            wait(3);
        };
        
        if ((UserIDDetect == 9) && (clkcheck9 == 0) && (reset == 0)){//If 1, it is the registered print, clkcheck 0 means the last action was a clock out
            N5110.clear();

            N5110.printString("User 9",1,1);
            N5110.printString("Clocked in",1,2);
            serial.printf("Clocked in" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:9");
            N5110.refresh();
            clkcheck9 = -1;
            reset = 1;//Clock in and out both require reset 0, and both change reset to 1 for 3 seconds to stop the code automaticlaly switching between both while UserIDDetect = 1
            wait(3);
        };
        
        
        if ((UserIDDetect == 9) && (clkcheck9 == -1) && (reset == 0)){
            N5110.clear();

            N5110.printString("User 9",1,1);
            N5110.printString("Clocked Out",1,2);
            serial.printf("Clocked Out" __DATE__);
            serial.printf("Time:"__TIME__);
            serial.printf("User:9");
            N5110.refresh();
            
            N5110.refresh();
            clkcheck9 = 0;
            reset = 1;
            wait(3);
        };
        
        GT511C3.WaitPress(0); //Code waits for no press before looping
    }
}
