#include "mbed.h"
#include "max32630fthr.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);    // set signal levels to 3v3

DigitalOut redLED(LED1);    // declare outputs
DigitalOut greenLED(LED2);
DigitalOut blueLED(LED3);

DigitalIn pushButton(P2_3, PullUp); // declare input. and set it to hi by default.

int main(){
    printf("So it has begun...\r\n");   // send message thru serial (view with laptop terminal)
    wait(1);    // wait 1 second
    
    redLED = LED_OFF;
    greenLED = LED_OFF;
    blueLED = LED_OFF;
    int roundabout = 0;
    while(1){
        
        if(pushButton==0){
            roundabout++;   // every push, increment color selector by 1
            
            // reset to dark before changing color
            redLED = LED_OFF;
            greenLED = LED_OFF;
            blueLED = LED_OFF;
            
            switch(roundabout){ // asks what will the new color be
                case 1:
                    redLED = LED_ON;    // red only
                    break;
                case 2:
                    greenLED = LED_ON;  // green only
                    break;
                case 3:
                    blueLED = LED_ON;   // blue only
                    break;
                case 4:
                    redLED = LED_ON;    // yellow
                    greenLED = LED_ON;
                    break;
                case 5:
                    greenLED = LED_ON;  // aqua
                    blueLED = LED_ON;
                    break;
                case 6:
                    blueLED = LED_ON;   // purple
                    redLED = LED_ON;
                    break;
                case 7:
                    redLED = LED_ON;    // white
                    greenLED = LED_ON;
                    blueLED = LED_ON;
                    break;
                default:
                    roundabout = 0;     // reset back to dark
                    break;
            }
            wait(1);    // wait 1 second before taking input signal again. without this, colors would switch very fast
        }
    }
}
