#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"
#include "max7219.h"
#define ESC 0x1B

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

// Hardware serial port over DAPLink
Serial daplink(USBTX, USBRX);

// declare pins
DigitalOut bLED(LED3);
DigitalIn push(P2_3, PullUp);


int main(){
    
    for(int ii=0;ii<3;ii++){    // blink blue 3 times
        bLED = LED_OFF;
        wait(0.5);
        bLED = LED_ON;
        wait(0.5);
        bLED = LED_OFF;
    }
    
    Max7219 segDriver(P5_1, P5_2, P5_0, P4_7);
    
    max7219_configuration_t segConfig = {
        .device_number = 1,
        .decode_mode = 0x0f,
        .intensity = Max7219::MAX7219_INTENSITY_F,
        .scan_limit = Max7219::MAX7219_SCAN_4
    };

    char buffer[32];
    daplink.printf("%c[2J", ESC); //clear screen
    daplink.printf("%c[H", ESC); //move cursor to Home
    daplink.printf("< 7SEG DEMO >\r\n\n");
    
    segDriver.set_display_test();
    wait(0.5);
    segDriver.clear_display_test();
    segDriver.init_device(segConfig);
    segDriver.enable_device(1);
    segDriver.clear_digit(1, Max7219::MAX7219_D0_P0);
    wait(0.5);
    
    int number = 0;
    while(1){
        daplink.printf("display #%d\r\n\n",number);
        segDriver.write_digit(1, Max7219::MAX7219_D0_P0, number);
        wait(1);
        
        if(number==15) number = 0;
        else number++;
    }
}
