#include "mbed.h"

Serial pc(USBTX,USBRX);

int main()
{

    while(1) {

        char dataBuffer[100];
        int num;
        char header[5];
        char checksum[3];

        if (pc.readable()) {  //if there is a character in the serial buffer
            pc.scanf("%s",dataBuffer); //read a string of characters into the buffer

            num=sscanf(dataBuffer,"$%5s",header);

            if (!strcmp("GPRMC",header)) {

                pc.printf("GPS Message Received: \n");
                int time;
                float lat,lon,elev;
                char dirNS,dirEW;
                num= sscanf(dataBuffer,"$%5s,%d,%f,%c,%f,%c,%f,*%2s",header,&time,&lat,&dirNS,&lon,&dirEW,&elev,checksum);

                if (num !=8) { //wrong # of arguments
                    pc.printf("String incorrectly Formatted \n");
                } else {
                    pc.printf("Time: %d seconds \n",time);
                    pc.printf("Latitude: %.4f degrees %c \n", lat,dirNS);
                    pc.printf("Longitude: %.4f degrees %c \n",lon,dirEW);
                    pc.printf("Elevation: %.2f m \n",elev);
                }
            }

            if (!strcmp("IMUPO",header)) {
                pc.printf("Motion message received: \n");

                int time;
                float Ax, Ay, Az;
                num=sscanf(dataBuffer,"$%5s,%d,%f,%f,%f,*%2s", header, &time,
                           &Ax,&Ay,&Az, checksum);

                if (num !=6) {
                    pc.printf("String incorrectly formatted \n");
                } else {
                    pc.printf("Time: %d seconds \n",time);
                    pc.printf("X-Acceleration: %f ms^-2 \n",Ax);
                    pc.printf("Y-Acceleration: %f ms^-2 \n",Ay);
                    pc.printf("Z-Acceleration: %f ms^-2 \n",Az);
                }
            }

            if (!strcmp("TEMPE",header)) {
                pc.printf("Temperature Message Received: \n");
                int time;
                float temp;
                num=sscanf(dataBuffer,"$%5s,%d,%f,*%2s",header,&time,&temp,checksum);

                if (num !=4) {
                    pc.printf("Incorrectly formatted string \n");
                } else {
                    pc.printf("Time: %d seconds \n",time);
                    pc.printf("Temperature: %.2f deg Celsius \n",temp);
                }
            } else {
                pc.printf("Header Not recognized \n");
            }
        }
    }
}