

#include "mbed.h"
#include "Serial_HL.h"
#include "Bertl14.h"
#include "BertlObjects.h"

//              main=2^0  LS    ENC 2^2
BusOut boardPow(p30,      P1_6, P1_7);

// ls5 nur beim Betrl15
AnalogInHL ls1(p18), ls2(p16), ls3(p19), ls4(p17); // B14
void FollowLineUntilEnd();
void TurnUntilLine();

int main(void)
{
    InitBertl();
    pex.useISR=0; leds=9;
    pex.ClearLeds();
    pex.WaitUntilButtonPressed();
    boardPow = 3;
    wait_ms(10);
        
    while(1)
    {

     FollowLineUntilEnd();
     wait_ms(1000);
     TurnUntilLine();
     wait_ms(1000);
     }
}   

void FollowLineUntilEnd()
{
    mL.SetPow(0.2); mR.SetPow(0.2);
    
    while(1)
    {
        if(ls1.Read() > 900)
        {
            mL.SetPow(0); mR.SetPow(0.8);
        }  
        else
        {
            mL.SetPow(0.8); mR.SetPow(0);
        }  
        
        if(ls1.Read() < 300 && ls2.Read() < 300 && ls3.Read() < 300 && ls4.Read() < 300)
        {
            mL.SetPow(0); mR.SetPow(0);
            return;
        }
        
    }
}
    
void TurnUntilLine()
{
    mL.SetPow(0.8); mR.SetPow(-0.8);
    while(1)
    {        
        if(ls1.Read() > 900 || ls2.Read() > 900 || ls3.Read() > 900 || ls4.Read() > 900)
        {
            mL.SetPow(0);mR.SetPow(0); 
            return;
        }
        
    }
}
        