#include "mbed.h"
//---------------------------------
#include "SDFileSystem.h"
//---------------------------------
#include "GPS.h"
//---------------------------------
#include "DHT.h"
//---------------------------------
#include "MMA7455.h"
//---------------------------------
#define PI 3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253
//---------------------------------
SDFileSystem sd(p5, p6, p7, p8, "sd");
DHT sensor(D7,DHT22);
MMA7455 acc(p32,p31);
Serial wind(P0_2, P0_3);
Serial Mod(p9, p10);
AnalogIn adc(p15);
AnalogIn adc(p16);

void task_GPS();
void task_MMA();
void task_DHT();
void task_windy();
void task_resist();
void task_current();
void task_extend();

Timer timer;
Timer timer2;

struct tm t;
struct tm t1;
int main() {
        t.tm_sec = 37;    // 0-59
        t.tm_min = 58;    // 0-59
        t.tm_hour = 23;   // 0-23
        t.tm_mday = 28;   // 1-31
        t.tm_mon = 1;    // 0-11
        t.tm_year = 117;  // year since 1900
        
        t1.tm_sec = 37;    // 0-59
        t1.tm_min = 58;    // 0-59
        t1.tm_hour = 23;   // 0-23
        t1.tm_mday = 28;   // 1-31
        t1.tm_mon = 1;    // 0-11
        t1.tm_year = 117;  // year since 1900
        
        time_t seconds = mktime(&t);
        set_time(seconds);    
        
        time_t second = mktime(&t1);
        set_time(second);   
        
        mkdir("/sd/DHT", 0777);
        mkdir("/sd/MMA", 0777);
        mkdir("/sd/GPS",0777);
        mkdir("/sd/resist", 0777);
        mkdir("/sd/windy", 0777);
        mkdir("/sd/current",0777);
        mkdir("/sd/extend",0777);
        
        timer.start();
        timer2.start();
        acc.setMode(MMA7455::ModeMeasurement);
        acc.setRange(MMA7455::Range_2g);
        acc.calibrate();
        
         t.tm_mon+=1;
         t1.tm_mon+=1;
    while(1) {
        if(timer.read()>3){
             t.tm_min+=1;      
            if(t.tm_min>59){
               t.tm_min=0;
               t.tm_hour++;
            }
            if(t.tm_hour>23){
               t.tm_hour=0;
               t.tm_mday++;
            }
            if((t.tm_mday>31)&&((t.tm_mon==1)||(t.tm_mon==3)||(t.tm_mon==5)||(t.tm_mon==7)||(t.tm_mon==8)||(t.tm_mon==10)))
            {
                t.tm_mon+=1;
                t.tm_mday=1;
            }
            if((t.tm_mday>31)&&(t.tm_mon==12))
            {
                t.tm_mon=1;
                t.tm_mday=1;
                t.tm_year++;
            }
            if((t.tm_mday>28)&&(t.tm_mon==2)&&((((1900+t.tm_year)/4)!=0)||((((1900+t.tm_year)/100)==0)&&((1900+t.tm_year)/400)!=0)))
            {
                t.tm_mon+=1;
                t.tm_mday=1;
            }
            if((t.tm_mday>29)&&(t.tm_mon==2)&&((((1900+t.tm_year)/400)==0)||((((1900+t.tm_year)/4)==0)&&((1900+t.tm_year)/100)!=0)))
            {
                t.tm_mon+=1;
                t.tm_mday=1;
            }
            if((t.tm_mday>30)&&((t.tm_mon==4)||(t.tm_mon==6)||(t.tm_mon==8)||(t.tm_mon==9)))
            {
                t.tm_mon+=1;
                t.tm_mday=1;
            }        
             task_GPS();
             task_windy();
             task_DHT();
             timer.reset();
         }
       if(timer2.read()> 10){
         t1.tm_min+=1; 
            if(t1.tm_min>59){
               t1.tm_min=0;
               t1.tm_hour++;
            }
            if(t1.tm_hour>23){
               t1.tm_hour=0;
               t1.tm_mday++;
            }
            if((t1.tm_mday>31)&&((t1.tm_mon==1)||(t1.tm_mon==3)||(t1.tm_mon==5)||(t1.tm_mon==7)||(t1.tm_mon==8)||(t1.tm_mon==10)))
            {
                t1.tm_mon+=1;
                t1.tm_mday=1;
            }
            if((t1.tm_mday>31)&&(t1.tm_mon==12))
            {
                t1.tm_mon=1;
                t1.tm_mday=1;
                t1.tm_year++;
            }
            if((t1.tm_mday>28)&&(t1.tm_mon==2)&&((((1900+t1.tm_year)/4)!=0)||((((1900+t1.tm_year)/100)==0)&&((1900+t1.tm_year)/400)!=0)))
            {
                t1.tm_mon+=1;
                t1.tm_mday=1;
            }
            if((t1.tm_mday>29)&&(t1.tm_mon==2)&&((((1900+t1.tm_year)/400)==0)||((((1900+t1.tm_year)/4)==0)&&((1900+t1.tm_year)/100)!=0)))
            {
                t1.tm_mon+=1;
                t1.tm_mday=1;
            }
            if((t1.tm_mday>30)&&((t1.tm_mon==4)||(t1.tm_mon==6)||(t1.tm_mon==8)||(t1.tm_mon==9)))
            {
                t1.tm_mon+=1;
                t1.tm_mday=1;
            }         
         task_MMA();
         task_resist();
         task_current();
         task_extend();
         timer2.reset();
        }
    } 
}
//----------------------------------------------------------
void task_resist(){ 
char filename[64];
int command[8]={0x08, 0x03, 0x00, 0x01, 0x00, 0x02,0x95,0x52};
char receice[8]={0};
int j=0;

        for (int i=0; i<8; i++) {
            while(1)
            {
            if (Mod.writeable())
            {
            Mod.putc(command[i]);
            break;
                }
            }
        }

        for (int i=0; i<8; i++) {
                            while (j<7) {
                                if (Mod.readable()) {
                                    receice[i]= Mod.getc();
                                    if(j>5)
                                    {
                                        sprintf(filename, "/sd/resist/%02d%02d%02d%02d%02d.txt",t1.tm_year-100,t1.tm_mon,t1.tm_mday,t1.tm_hour,t1.tm_min);
                                        FILE *fp = fopen(filename, "a");
                                                fprintf(fp,"%.1f\r\n",((receice[3] << 8) + receice[4])/100.0);         
                                         fclose(fp);           
                                        printf("Resistance:%.1fΩ\r\n", ((receice[3] << 8) + receice[4])/100.0);
                                        j++;
                                    }
                                    j++;
                                    break;
                                }
                    }
    
        }                        
}
//----------------------------------------------------------
void task_windy(){
char filename[64];
char command[17];
int i = 0;
int j=1;
float  windSpeed;
int windDirection;
            for(j=1;j<17;j++)
            {
                command[i]= wind.getc();
                i++;
            }
         printf("\r\n");  
         if(command[0]==0x3A){
         windSpeed=((command[8]-48)*10000+(command[9]-48)*1000+(command[10]-48)*100+(command[12]-48)*10+(command[13]-48))/100.0;
         windDirection= (command[4]-48)*100+(command[5]-48)*10+(command[6]-48);
         
         sprintf(filename, "/sd/windy/%02d%02d%02d%02d%02d.txt",t.tm_year-100,t.tm_mon,t.tm_mday,t.tm_hour,t.tm_min);
         FILE *fp = fopen(filename, "a");
                fprintf(fp,"%.2f\t",windSpeed);
                fprintf(fp,"%d\r\n",windDirection);         
         fclose(fp);           
         
         printf("The Wind Speed is %.2f (m/s)\r\n",windSpeed);
         printf("The Wind Direction is %d",windDirection);
         }
         printf("\r\n");   
}
//----------------------------------------------------------
void task_MMA(){
    char filename[64];
    int32_t x,y,z;
    double x1,y1,z1;
    double xg,yg,zg;
    double xd,yd,zd;
        acc.read(x,y,z);

        xg=x*0.016; //實際g值
        yg=y*0.016; //實際g值
        zg=z*0.016; //實際g值

        x1=xg/(sqrt(pow(yg,2.0)+pow(zg,2.0)));
        y1=yg/(sqrt(pow(xg,2.0)+pow(zg,2.0)));
        z1=(sqrt(pow(yg,2.0)+pow(xg,2.0)))/zg;

        xd=atan(x1); //徑度
        yd=atan(y1); //徑度
        zd=atan(z1); //徑度
            
            printf("xd: %.2f ",xd*180.0/PI);
            printf("yd: %.2f ",yd*180.0/PI);
            printf("zd: %.2f ",zd*180.0/PI);
           sprintf(filename, "/sd/MMA/%02d%02d%02d%02d%02d.txt",t1.tm_year-100,t1.tm_mon,t1.tm_mday,t1.tm_hour,t1.tm_min);
           FILE *fp = fopen(filename, "a");
                fprintf(fp,"%.2f\t",xd*180.0/PI);
                fprintf(fp,"%.2f\t",yd*180.0/PI);
                fprintf(fp,"%.2f\r\n",zd*180.0/PI);
            fclose(fp); 
            printf("\r\n\n");
}
//----------------------------------------------------------
void task_DHT(){
    int error = 0;
    int h, c,f;
    float dp = 0.0f;
    char filename[64]; 
 
        wait(2.0f);
        error = sensor.readData();
        if (0 == error) {
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
            sprintf(filename, "/sd/DHT/%02d%02d%02d%02d%02d.txt",t.tm_year-100,t.tm_mon,t.tm_mday,t.tm_hour,t.tm_min);
            FILE *fp = fopen(filename, "a");  
                fprintf(fp,"%d\t",c);
                fprintf(fp,"%d\t",f);
                fprintf(fp,"%d\t",h);
                fprintf(fp,"%4.2f\r\n",dp);
            fclose(fp); 
            printf("Temperature in Celcius: %d, Farenheit %d\r\n", c, f);
            printf("Humidity is %d, Dewpoint: %4.2f\r\n\n", h, dp);
        } else {
            printf("Error: %d\r\n", error);
        }
}
//-----------------------------------------------
void task_current(){
int i,j,temp;
char filename[64];
int test[11240];
    for(i=0;i<11240;i++)
        {
            test[i] = adc.read_u16();
        }
     for(j=0;j<11239;j++){
        if(test[j]>test[j+1]){
           temp=test[j];
           test[j+1]=test[j];
           test[j+1]=temp;
            }
        }
        sprintf(filename, "/sd/current/%02d%02d%02d%02d%02d.txt",t1.tm_year-100,t1.tm_mon,t1.tm_mday,t1.tm_hour,t1.tm_min);
                    FILE *fp = fopen(filename, "a");
                    fprintf(fp,"%.3f\r\n",(test[11239]*3.3/65535));         
        fclose(fp);   
            printf("%f \r\n", (test[11239]*3.3/65535));
        wait(1);
}
//-------------------------------------
void task_GPS(){
    int ret;
    char filename[64];
#ifdef LARGE_DATA
    char buf[2048] = "";
#else
    char buf[512] = "";
#endif
#if 1  
    GPSI2C gps;
#else  
    GPSSerial gps; 
#endif
    int count=0;

    while (count==0) {
#ifndef CELLOCATE
        while ((ret = gps.getMessage(buf, sizeof(buf))) > 0)
        {
            int len = LENGTH(ret);
            if ((PROTOCOL(ret) == GPSParser::NMEA) && (len > 6))
            {
                if ((buf[0] == '$') || buf[1] == 'G') {
                    #define _CHECK_TALKER(s) ((buf[3] == s[0]) && (buf[4] == s[1]) && (buf[5] == s[2]))
                    if (_CHECK_TALKER("GLL")) {
                        double la = 0, lo = 0;
                        char ch;
                        if (gps.getNmeaAngle(1,buf,len,la) && 
                            gps.getNmeaAngle(3,buf,len,lo) && 
                            gps.getNmeaItem(6,buf,len,ch) && ch == 'A')
                        {
                            sprintf(filename, "/sd/GPS/%02d%02d%02d%02d%02d.txt",t.tm_year-100,t.tm_mon,t.tm_mday,t.tm_hour,t.tm_min);
                             FILE *fp = fopen(filename, "a");
                                    fprintf(fp,"%.5f %.5f\r\n", la, lo);        
                             fclose(fp);         
                            printf("GPS Location: %.5f %.5f\r\n", la, lo);  
                        }
                    } else if (_CHECK_TALKER("GGA") || _CHECK_TALKER("GNS") ) {
                        double a = 0; 
                        if (gps.getNmeaItem(9,buf,len,a)) // altitude msl [m]
                        {
                            sprintf(filename, "/sd/GPS/%02d%02d%02d%02d%02d.txt",t.tm_year-100,t.tm_mon,t.tm_mday,t.tm_hour,t.tm_min);
                             FILE *fp = fopen(filename, "a");
                                     fprintf(fp,"%.1f\r\n", a);
                             fclose(fp);
                                printf("GPS Altitude: %.1f\r\n", a);
                        } 
                    } 
                }
                count++;
            }
        }
        if((ret = gps.getMessage(buf, sizeof(buf))) < 0)
        {
           
        }
#endif              
    }
}
//---------------------------
void task_extend(){
    sprintf(filename, "/sd/extend/%02d%02d%02d%02d%02d.txt",t1.tm_year-100,t1.tm_mon,t1.tm_mday,t1.tm_hour,t1.tm_min);
                    FILE *fp = fopen(filename, "a");
                    fprintf(fp,"%.3f\r\n",adc.read_u16()*3.3/65535/0.29);         
    fclose(fp);   
}