#include "mbed.h"
#include "DHT.h"

DHT sensor(D7,DHT22);

void task_DHT();

int main()
{   
    
    while(1) {
         task_DHT();
    }
}
void task_DHT(){
    int error = 0;
    int h, c,f;
    float dp = 0.0f;
 
        wait(2.0f);
        error = sensor.readData();
        if (0 == error) {
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
    
            printf("Temperature in Celcius: %d, Farenheit %d\r\n", c, f);
            printf("Humidity is %d, Dewpoint: %4.2f\r\n\n", h, dp);
        } else {
            printf("Error: %d\r\n", error);
        }
}
