#include "mbed.h"
#include "MMA7455.h"
#include "MDM.h"

#define PI 3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253

#define SIMPIN      "1922"

#define APN         NULL
//! Set the user name for your APN, or NULL if not needed
#define USERNAME    NULL
//! Set the password for your APN, or NULL if not needed
#define PASSWORD    NULL 

MMA7455 acc(p32,p31);

void task_MMA();


double a,b,c;
char str[90];
char str1[90];
char str2[90];
int main(void)
{
    acc.setMode(MMA7455::ModeMeasurement);
    acc.setRange(MMA7455::Range_2g);
    acc.calibrate();
    
    int ret;
#ifdef LARGE_DATA
    char buf[2048] = "";
#else
    char buf[512] = "";
#endif
    
    MDMSerial mdm; 
    MDMParser::DevStatus devStatus = {};
    MDMParser::NetStatus netStatus = {};
    bool mdmOk = mdm.init(SIMPIN, &devStatus);
    mdm.dumpDevStatus(&devStatus);
    
    
    
    task_MMA();
    
    
    
    if (mdmOk) {
#if 0
        // file system API
        const char* filename = "File";
        char buf[] = "Hello World";
        printf("writeFile \"%s\"\r\n", buf);
        if (mdm.writeFile(filename, buf, sizeof(buf)))
        {
            memset(buf, 0, sizeof(buf));
            int len = mdm.readFile(filename, buf, sizeof(buf));
            if (len >= 0) 
                printf("readFile %d \"%.*s\"\r\n", len, len, buf);
            mdm.delFile(filename);
        }
#endif
        mdmOk = mdm.registerNet(&netStatus);
        mdm.dumpNetStatus(&netStatus);
    }
    if (mdmOk)
    {
        // join the internet connection 
        MDMParser::IP ip = mdm.join(APN,USERNAME,PASSWORD);
        if (ip == NOIP)
            printf("Not able to join network");
        else
        {
            mdm.dumpIp(ip);
            printf("Make a Http Post Request\r\n");
            int socket = mdm.socketSocket(MDMParser::IPPROTO_TCP);
            if (socket >= 0)
            {
                mdm.socketSetBlocking(socket, 10000);
                if (mdm.socketConnect(socket, "140.118.206.213", 555))
                {
                    mdm.socketSend(socket, str, sizeof(str)-1);
                
                    ret = mdm.socketRecv(socket, buf, sizeof(buf)-1);
                    if (ret > 0)
                        printf("Socket Recv \"%*s\"\r\n", ret, buf);
                    mdm.socketClose(socket);
                }
                mdm.socketFree(socket);
            }
            
            int port = 7;
            const char* host = "echo.u-blox.com";
            MDMParser::IP ip = mdm.gethostbyname(host);
            char data[] = "\r\nxxx Socket Hello World\r\n"
#ifdef LARGE_DATA
                        "00  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        "01  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        "02  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        "03  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        "04  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        
                        "05  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        "06  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        "07  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        "08  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        "09  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
            
                        "10  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        "11  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        "12  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        "13  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        "14  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        
                        "15  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        "16  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        "17  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        "18  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
                        "19  0123456789 0123456789 0123456789 0123456789 0123456789 \r\n"
#endif            
                        "End\r\n";
                
            printf("Testing TCP sockets with ECHO server\r\n");
            socket = mdm.socketSocket(MDMParser::IPPROTO_TCP);
            if (socket >= 0)
            {
                mdm.socketSetBlocking(socket, 10000);
                if (mdm.socketConnect(socket, host, port)) {
                    memcpy(data, "\r\nTCP", 5); 
                    ret = mdm.socketSend(socket, data, sizeof(data)-1);
                    if (ret == sizeof(data)-1) {
                        printf("Socket Send %d \"%s\"\r\n", ret, data);
                    }
                    ret = mdm.socketRecv(socket, buf, sizeof(buf)-1);
                    if (ret >= 0) {
                        printf("Socket Recv %d \"%.*s\"\r\n", ret, ret, buf);
                    }
                    mdm.socketClose(socket);
                }
                mdm.socketFree(socket);
            }

            printf("Testing UDP sockets with ECHO server\r\n");
            socket = mdm.socketSocket(MDMParser::IPPROTO_UDP, port);
            if (socket >= 0)
            {
                mdm.socketSetBlocking(socket, 10000);
                memcpy(data, "\r\nUDP", 5); 
                ret = mdm.socketSendTo(socket, ip, port, data, sizeof(data)-1);
                if (ret == sizeof(data)-1) {
                    printf("Socket SendTo %s:%d " IPSTR " %d \"%s\"\r\n", host, port, IPNUM(ip), ret, data);
                }
                ret = mdm.socketRecvFrom(socket, &ip, &port, buf, sizeof(buf)-1);
                if (ret >= 0) {
                    printf("Socket RecvFrom " IPSTR ":%d %d \"%.*s\" \r\n", IPNUM(ip),port, ret, ret,buf);
                }
                mdm.socketFree(socket);
            }
            
            // disconnect  
            mdm.disconnect();
        }
    
        const char* ussd = "*130#"; // You may get answer "UNKNOWN APPLICATION"
        printf("Ussd Send Command %s\r\n", ussd);
        ret = mdm.ussdCommand(ussd, buf);
        if (ret > 0) 
            printf("Ussd Got Answer: \"%s\"\r\n", buf);
    }
#ifdef CELLOCATE    
    const int sensorMask = 3;  // Hybrid: GNSS + CellLocate       
    const int timeoutMargin = 5; // seconds
    const int submitPeriod = 60; // 1 minutes in seconds
    const int targetAccuracy = 1; // meters
    unsigned int j = submitPeriod * 1000/wait;
    bool cellLocWait = false;
    MDMParser::CellLocData loc;
    
    if (!mdm.cellLocSrvHttp("TOKEN"))
            mdm.cellLocSrvUdp();        
    mdm.cellLocConfigSensor(1);   // Deep scan mode
   
#endif
    mdm.powerOff();
    return 0;
}
void task_MMA(){

    
    char filename[64];
    int32_t x,y,z;
    double x1,y1,z1;
    double xg,yg,zg;
    double xd,yd,zd;
        acc.read(x,y,z);

        xg=x*0.016; //實際g值
        yg=y*0.016; //實際g值
        zg=z*0.016; //實際g值

        x1=xg/(sqrt(pow(yg,2.0)+pow(zg,2.0)));
        y1=yg/(sqrt(pow(xg,2.0)+pow(zg,2.0)));
        z1=(sqrt(pow(yg,2.0)+pow(xg,2.0)))/zg;

        xd=atan(x1); //徑度
        yd=atan(y1); //徑度
        zd=atan(z1); //徑度
        
        a=xd*180.0/PI;
        b=yd*180.0/PI;
        c=zd*180.0/PI;
        
        sprintf(str,"%.2f\t",a);
        sprintf(str1,"%.2f\t",b);
        sprintf(str2,"%.2f",c);
        
        strcat(str,str1);
        strcat(str,str2);
        
        puts(str);
  
       
            printf("xd: %.2f ",xd*180.0/PI);
            printf("yd: %.2f ",yd*180.0/PI);
            printf("zd: %.2f ",zd*180.0/PI);
            printf("\r\n\n");
}