/* Bible UI Class Definition - KJV Bible eBook Browser
 *
 * Copyright (c) 2011 David R. Van Wagner davervw@yahoo.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include <mbed.h>
#include "BibleIO.h"
#include "TextLCD.h"

class BibleUI
{
private:
    short book;
    short chapter;
    short verse;
    short offset;
    short disp_len;
    BibleIO &HolyBible;
    TextLCD &lcd;
    DigitalIn& lb;
    DigitalIn& rb;
    DigitalOut led1;
    DigitalOut led2;
    DigitalOut led3;
    DigitalOut led4;

public:
    BibleUI(BibleIO &bible, TextLCD &textlcd, DigitalIn& left, DigitalIn& right);
    void start();
    static void indexing(int progress, void* context);

private:
    void display_nav();
    void display_verse();
    void show_title();
    void main();
    bool append_next_verse(char*& text, short len, short book, short chapter, short verse);
    void remove_string(char* &text, char* find);
    int word_wrap(char* &text);
};
