/* KJV Bible eBook Browser
 *
 * Copyright (c) 2011 David R. Van Wagner davervw@yahoo.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include <mbed.h>
#include "SDHCFileSystem.h"
#include "TextLCD.h"
#include "BibleIO.h"
#include "BibleUI.h"

//Serial console(USBTX, USBRX);

int main() 
{
    //console.baud(921600); // mbed to pc usb serial supports: 110, 300, 600, 1200, 2400, 4800, 9600, 14400, 19200, 38400, 57600, 115200, 230400, 460800, 921600
    //console.printf("Bible\n");

    TextLCD lcd(p15, p16, p17, p18, p19, p20, TextLCD::LCD8x2); // rs, e, d4, d5, d6, d7, LCD type
    //lcd.printf("Bible\n");
    
    SDFileSystem sd(p5, p6, p7, p8, "sd"); // mosi, miso, sclk, cs, mount point
    BibleIO HolyBible("/sd/bible.txt", BibleUI::indexing, &lcd);

    DigitalIn left(p21);
    DigitalIn right(p22);
    left.mode(PullDown);
    right.mode(PullDown);

    // go UI
    BibleUI ui(HolyBible, lcd, left, right); // Bible, TextLCD, left button, right button
    ui.start();
}
