// c-simple-emu-cbm.cs - main()
//
////////////////////////////////////////////////////////////////////////////////
//
// c-simple-emu-cbm (C Portable Version)
// C64/6502 Emulator for Terminal Console
//
// MIT License
//
// Copyright(c) 2020 by David R. Van Wagner
// davevw.com
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
////////////////////////////////////////////////////////////////////////////////

#include <mbed.h>
#include "cbmconsole.h"
#include "emuc64.h"
#include "emu6502.h"

#ifdef LOCAL_LOAD
#include <LocalFileSystem.h>
LocalFileSystem local("local");
#endif

Serial pc(USBTX, USBRX, 115200);
//Serial pc(p9, p10, 115200);

int main(/*int argc, char* argv[]*/)
{
    pc.printf("\n");
	pc.printf("c-simple-emu-cbm version 1.7 for Mbed\n");
	pc.printf("Copyright (c) 2020 by David R. Van Wagner\n");
	pc.printf("Open Source - MIT License\n");
	pc.printf("github.com/davervw\n");
	pc.printf("\n");
	pc.printf("Contains other licensed software\n");
	pc.printf("   ARM MBED OS\n");
	pc.printf("\n");
	pc.printf("Commodore ROMs not licensed\n");
	pc.printf("\n");

#ifdef LOCAL_LOAD
    // note: requires a file system implementation (SD, Mbed MSD, etc.)
	StartupPRG = "/local/startup.prg";
#endif	
	
	C64_Init("/local/basic", "/local/chargen", "/local/kernal");
	ResetRun(ExecutePatch);
	return 0;
}
