/* mbed TextLCD5110 Library, for a Nokia 5110 Lcd
 * Original Copyright (c) 2007-2010, sford, http://mbed.org
 * Revisions Copyright (c) 2014, David R. Van Wagner, https://mbed.org/users/davervw/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "TextLCD_NOKIA_5110.h"
#include "mbed.h"

TextLCD5110::TextLCD5110(PinName mosi, PinName sclk, PinName dc, PinName cse, 
    PinName reset)
{
    LcdPins pins = { mosi, NC, sclk, dc, cse, reset };
    pLcd = new NokiaLcd( pins ); // SPI is started here (8-bits, mode 1)
    pLcd->InitLcd();             // LCD is reset and DDRAM is cleared
        locate(0, 0);
}

void TextLCD5110::character(int column, int row, int c) {
    locate(column, row);
    pLcd->DrawChar(c);
}

void TextLCD5110::cls() {
    pLcd->ClearLcdMem();
    locate(0, 0);
}

void TextLCD5110::locate(int column, int row) {
        _column = column;
        _row = row;
    pLcd->SetXY(column*6, row);
}

int TextLCD5110::_putc(int value) {
    if (value == '\n') {
        _column = 0;
        _row++;
        if (_row >= rows()) {
            _row = 0;
        }
    } else {
        character(_column, _row, value);
        _column++;
        if (_column >= columns()) {
            _column = 0;
            _row++;
            if (_row >= rows()) {
                _row = 0;
            }
        }
    }
    return value;
}

int TextLCD5110::_getc() {
    return -1;
}

int TextLCD5110::columns() {
    return 14;
}

int TextLCD5110::rows() {
    return 6;
}

int TextLCD5110::get_column() {
    return _column;
}

int TextLCD5110::get_row() {
    return _row;
}
