///////////////////////////////////////////////////////////////////////////////
// SPIDebug.h
//
// COPYRIGHT (c) 2012 by David Van Wagner
//
// dave@vanwagner.org
// http://techwithdave.blogspot.com
//
// License: Creative Commons Attribution-ShareAlike 3.0 Unported License
// http://creativecommons.org/licenses/by-sa/3.0/
///////////////////////////////////////////////////////////////////////////////

#include "SPIDebug.h"

bool SPIDebug::debug = true; // default on

SPIDebug::SPIDebug(PinName mosi, PinName miso, PinName sclk, const char *name)
{
    if (debug)
        printf("SPI(%08x, %08x, %08x, %s)\n", mosi, miso, sclk, name);
    spi = new SPI(mosi, miso, sclk, name);
}

SPIDebug::~SPIDebug()
{
    delete spi;
}

void SPIDebug::format(int bits, int mode)
{
    if (debug)
        printf("SPI.format(%d, %d)\n", bits, mode);
    spi->format(bits, mode);
}

void SPIDebug::frequency(int hz)
{
    if (debug)
        printf("SPI.frequency(%d)\n", hz);
    spi->frequency(hz);
}

int SPIDebug::write(int value)
{
    int result = spi->write(value);
    if (debug)
        printf(">%02x <%02x ", value, result);
    return result;
}

CSDebug::CSDebug(PinName pin)
{
    cs = new DigitalOut(pin);
}

CSDebug::~CSDebug()
{
    delete cs;
}

void CSDebug::write(bool state)
{
    cs->write(state);
    if (SPIDebug::debug)
    {
        if (state == false)
            printf("SPI CS\n");
        else
            printf("\n");
    }
}
