///////////////////////////////////////////////////////////////////////////////
// SPIDebug.h
//
// COPYRIGHT (c) 2012 by David Van Wagner
//
// dave@vanwagner.org
// http://techwithdave.blogspot.com
//
// License: Creative Commons Attribution-ShareAlike 3.0 Unported License
// http://creativecommons.org/licenses/by-sa/3.0/
///////////////////////////////////////////////////////////////////////////////

#include <mbed.h>

class SPIDebug
{
private:
    SPI* spi;
    
public:
    SPIDebug(PinName mosi, PinName miso, PinName sclk, const char *name = NULL);
    virtual ~SPIDebug();
    void format(int bits, int mode = 0);
    void frequency(int hz = 10000000);
    virtual int write(int value);
    static bool debug; // allow to be changed to control whether there are debug messages
};

class CSDebug
{
private:
    DigitalOut* cs;

public:
    CSDebug(PinName pin);
    ~CSDebug();
    void write(bool state);
};
