#include <mbed.h>
#include "SDHCFileSystem.h"

#define DEBUG_LINE printf("%d\n", __LINE__);

Serial console(USBTX, USBRX);

void exitmsg(const char* message, int lineno)
{
   fprintf(stderr, "%s at line# %d\n", message, lineno);
   exit(1);
}

const int buffersize=1024;
char buffer[buffersize];

int main()
{
    SDFileSystem sd(p5, p6, p7, p8, "sd"); // mosi, miso, sclk, cs, mount point

    console.baud(921600); // mbed to pc usb serial supports: 110, 300, 600, 1200, 2400, 4800, 9600, 14400, 19200, 38400, 57600, 115200, 230400, 460800, 921600

    console.puts(
        "\x1b[2J\x1b[H"
        __FILE__ "\r\n"
        __DATE__ " " __TIME__ "\r\n"
        "\r\n");

    remove("/sd/sector.bin");
    FILE* fp = fopen("/sd/sector.bin", "w+");

    char *p = buffer;
    for (unsigned int i=0; i<buffersize/2; ++i)
    {
        *(p++) = i & 0xFF;
        *(p++) = i >> 8;
    }
    if (fwrite(buffer, sizeof(char), buffersize, fp) != buffersize)
        exitmsg("failed to write", __LINE__);

    fseek(fp, 0, SEEK_SET);
    if (fread(buffer, sizeof(char), buffersize, fp) != buffersize)
        exitmsg("failed to read", __LINE__);
         
    p = buffer;
    for (unsigned int i=0; i<buffersize/2; ++i)
    {
        unsigned char lo = (*p++);
        unsigned char hi = (*p++);
        unsigned int value = lo | ((int)hi << 8);
        
        if (value != i)
        {
            fprintf(stderr, "expected %d, got %d\n", i, value);
            exitmsg("failed", __LINE__);
        }
    }
    
    fprintf(stderr, "success\n");   
    
    fclose(fp);
}
