// main.cpp - main()
//
////////////////////////////////////////////////////////////////////////////////
//
// C64-stm429_discovery
// C64/6502 Emulator targeting STM32F429 LCD/USBHOST
// [ported from c-simple-emu-cbm (C Portable Version - for console)]
//
// MIT License
//
// Copyright(c) 2020 by David R.Van Wagner
// davevw.com
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
////////////////////////////////////////////////////////////////////////////////
// OTHER INCLUDED (NOT LIMITED TO) SOURCE/LIBRARIES MAY HAVE DIFFERENT LICENSES.
//    ARM MBED OS
//    ARM MBED USBHOST
//    STM32F429 BSP
////////////////////////////////////////////////////////////////////////////////

#include <mbed.h>
#include "USBHostKeyboard.h"
#include "emuc64.h"
#include "emu6502.h"

static void execute_task(void const *) {
	ResetRun(ExecutePatch);
}

int main(/*int argc, char* argv[]*/)
{
    printf("\n");
    printf("C64-stm429_discovery\n");
	printf("C64 Emu6502 (for STM32F429 Discovery), version 1.34\n");
	printf("Copyright (c) 2020 by David R. Van Wagner\n");
	printf("Open Source - MIT License\n");
	printf("os.mbed.com/users/davervw/code/C64-stm429_discovery/\n");
	printf("github.com/davervw\n");
	printf("\n");
	printf("Contains other copyrighted and licensed software\n");
	printf("   ARM MBED OS - Apache License 2.0\n");
	printf("   ARM MBED USBHOST - Apache License 2.0\n");
	printf("   STM32F429 Discovery Board BSP\n");
	printf("      COPYRIGHT(c) 2014 STMicroelectronics\n");
    printf("      Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution. 3. Neither the name of STMicroelectronics nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.\n");
    printf("      THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ""AS IS"" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n");
	printf("\n");
	printf("Commodore ROMs not licensed\n");
	printf("\n");
	
	//StartupPRG = "/local/guess2.prg";
	C64_Init("/local/basic", "/local/chargen", "/local/kernal");

    Thread keyboardTask(keyboard_task, NULL, osPriorityNormal, 1024 * 4);
    Thread executeTask(execute_task, NULL, osPriorityNormal, 1024 * 4);

	//DigitalOut led1(LED1);
	//led1 = 1;
    while(1) {
        //led1=!led1;
        Thread::wait(500);
    }

	return 0;
}
