/* Bible I/O Class Definition
 *
 * Copyright (c) 2011 David R. Van Wagner davervw@yahoo.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 * This class assumes bible text file is present and in a specific format extracted from source such as:
 *      http://printkjv.ifbweb.com/AV_txt.zip
 */

#ifndef BIBLE_H
#define BIBLE_H

#include "stdio.h"

class BibleIO
{

public:    
    BibleIO(char* text_filename, void (*indexing_callback)(int, void*), void* indexing_context);
    ~BibleIO();
    short get_num_books();
    short get_num_chapters(short book);
    short get_num_verses(short book, short chapter);
    char* title();
    char* title_book(short book);
    char* title_chapter(short book, short chapter);
    char* text_chapter(short book, short chapter);
    char* text_verse(short book, short chapter, short verse);
    bool bookmark_add(short book, short chapter, short verse);
    bool bookmark_del(short book, short chapter, short verse);
    bool bookmark_prev(short &book, short &chapter, short &verse);
    bool bookmark_next(short &book, short &chapter, short &verse);

private:
    struct chapter_index
    {
        long title_offset;
        long verses_offset[];
    };
     
    struct book_index
    {
        long title_offset;
        long num_chapters;
    };
    
    struct bible_index
    {
        long title_offset;
        book_index books[];
    };

    struct position
    {
        short book;
        short chapter;
        short verse;
        short rsvd; // for padding
    };

    char* text_filename;
    FILE* fp;
    char* name;
    bible_index* books;
    short num_books;
    position* bookmarks;
    short num_bookmarks;
    void (*indexing_callback)(int, void*);
    void* indexing_context;

    void build_index();
    void read_name();
    void format_book_name(char* &book_name);
    void read_preface();
    void read_books();
    bool read_book(FILE* index, short book);
    bool read_chapter(short book, short chapter);
    bool read_verse(FILE* index, short book, short chapter, short verse);
    char* read_line();
    bool load_index();
    bool load_bookmarks();
    bool save_bookmarks();
    char* index_path();
    char* index_path(char* name);
    char* index_path(short chapter);
    char* index_path(short book, short chapter);
};

#endif
