#include "counter.h"

//todo: implement 2k sample buffer and store results until client connects, implement real time clock

Serial pc(USBTX, USBRX);
counter SF800 (p29);
Timer t_a, t_b;

int main() {

    t_a.start();
    t_b.start();
    int a_init_pulses = 0;
    int b_init_pulses = 0;
    float flowrate = 0;
    int time_window = 10000;

    bool a_b_flip_flop = true; // if true use window a
    
    pc.printf("\n\r*************\n\rMBED restarted\n\r*************\n");

    while (1) {
        wait(0.1);

        if (a_b_flip_flop) {
            flowrate = (float)(SF800.getPulses() - a_init_pulses)/(6000 * t_a.read_ms() / 60000);
        } else {
            flowrate = (float)(SF800.getPulses() - b_init_pulses)/(6000 * t_b.read_ms() / 60000);
        }

        if (t_a.read_ms() > time_window) { // switch to window B
        
            pc.printf("\rswitching to window B = %i pulses detected in window A\n", SF800.getPulses() - a_init_pulses);
        
            t_a.reset();
            a_b_flip_flop = false;
            a_init_pulses =  SF800.getPulses();
        }
        
        if (t_a.read_ms() > time_window/2 && !a_b_flip_flop) { // switch to window A
        
            pc.printf("\rswitching to window A = %i pulses detected in window B\n", SF800.getPulses() - b_init_pulses);
        
            t_b.reset();
            a_b_flip_flop = true;
            b_init_pulses =  SF800.getPulses();
        }

        pc.printf("\rflowrate = %f l/min", flowrate);
    }

}
