#ifndef counter_H
#define counter_H

/**
 * Includes
 */
#include "mbed.h"

/**
 * Simple counter
 */
class counter {

public:

    
    /**
     * Constructor.
     *
     * Attaches the encode function to the rise/fall edge of
     * channels A.
     *
     * @param channelA mbed pin for counter input.
     */
    counter(PinName channelA);

    /**
     * Reset the encoder.
     *
     * Sets the pulses and revolutions count to zero.
     */
    void reset(void);

    /**
     * Read the number of pulses recorded by the encoder.
     *
     * @return Number of pulses which have occured.
     */
    int getPulses(void);

private:

    /**
     * Update the pulse count.
     *
     * Called on every rising edge of channels A.
     *
     */
    void encode(void);

    InterruptIn channelA_;
    
    volatile int pulses_;
    
};

#endif /* counter_H */
