
#include "mbed.h"
#include "si5351a.h"
    
    InterruptIn button(p18); // Interrupt on digital pushbutton input p18
    Timer debounce; // define debounce timer
    Ticker data_out;            // periodic interrupt routines
    Ticker clock_out;
    DigitalOut data(p16);
    DigitalOut clk(p17);
    DigitalOut swon(p21);
    DigitalOut swled(LED1);
    
    uint16_t divider, mode;
    uint32_t ref0,ref1,ref2;
    uint16_t *div_bin; // pointer
    int count_data,count_clk;

    I2C i2c(p28, p27);       // communication with Si5351A I2C_SDA=p28 & I2C_SCL=p27
    SI5351A ckref(i2c, 25000000UL);     // Base clock = 25MHz
    Serial pc(USBTX,USBRX); // setup terminal link
    LocalFileSystem local("local"); // define local file system
    
     uint16_t read_data (int );   
     uint16_t * set_dec2bin (uint16_t);
     void send_data (void);
     void send_clk (void);
     void toggle(void); // function prototype

        uint16_t read_data (int  mode) 
        {              
 //       char bitmode[10];
  //      char div[10];
 //       char reads[10], readc[10];
  //      char writes[10];
    //  char writec[10];
        uint16_t value;
        int i,j;
        char text[10][10]; // when the file exist and have data
        char line[10];     // it reads line by line

        for(i=0; i<10; i++)
        for(j=0; j<10; j++)
        text[i][j] = '\0';  // initializing the vector with null
        for(i=0; i<10; i++)
        line[i] = '\0';
               
                FILE* fp = fopen ("/local/div_prog.txt","r"); // open file for reading               
                if (fp!=NULL) 
                {
                        fseek (fp, 0, SEEK_END);
                        int  size = ftell(fp);
                            if (size==0) 
                            {
                            pc.printf("File is empty\n");
                            }
                            else
                            {
                            rewind (fp); // restore pointer to the begin of the file
                            i=0;
                                    while ( fgets ( line, sizeof line, fp ) != NULL ) /* read a line */
                                    {
                                    strcpy(text[i], line);
                                    printf("array ----> %s ", text[i]);
                                    i++;
                                    }
                                    fclose(fp); // close file
                            
                                    if(mode==0)
                                    {
                                    value=atoi(text[mode]);
                                    pc.printf("Divider value = %d \n",value); // display read data value
                                    }
                                    if(mode==1)
                                    {
                                    value=atoi(text[mode]);
                                                if (value==0)
                                                pc.printf("LSB Mode \n"); //
                                                if (value==1)
                                                pc.printf("MSB Mode \n"); //        
                                    }                             
                            }
                    }
                
                else
                {
                int num;    
                pc.printf("File does no exist \n");
                pc.printf("Enter the divider value \n: ");
                pc.printf("Byte to send LSB(0) or MSB(1)\n: ");
                
                  for(i=0; i<2; i++)  //just read to save to lines 
                  {
                      pc.scanf("%s", text[i]);
                      while (!(sscanf(text[i], "%d", &num)))
                            {
                            printf("Invalid input '%s'\n", text[i]);
                            pc.scanf("%s", text[i]);
                            }     
                  }                
 
                   
                }
                    
        //        FILE* fp2 = fopen("/local/div_prog.txt","w"); // open file
        //        memcpy(writes, div, sizeof writes);
        //        fputs(writes, fp2); // put char (data value) into file
        //        fclose(fp2); // close file
        //        value=atoi(writes);
        //        pc.printf("Divider valuec = %d \n",value); // display read data value
          
                return value;
        }
    
    uint16_t * set_dec2bin (uint16_t read_div) {
    int i;
     static uint16_t  r[12];
       /* for loop execution */
   for( i = 0; i < 12; i++ ){
      r[i]= read_div >> i & 1;
       pc.printf("%d",r[i]); // display read data value
   }
     pc.printf("\n"); 
     return r;
    }
        
               
    void send_data (void) {    
    if(count_data<12) {
        if(mode==0){
        data= *(div_bin+count_data);
        pc.printf("%d",*(div_bin+count_data));
        count_data=count_data+1;
        }
        if(mode==1) {
        data= *(div_bin+11-count_data);
        pc.printf("%d",*(div_bin+11-count_data));
        count_data=count_data+1;
        }
 
    }
    else {
    data=0;
  //  count_data=0;
   // pc.printf("\n");
    }
    
    }
    
    void send_clk (void){
          if(count_clk<24) {
              clk=!clk;
   //     pc.printf("d%d",clk);
        count_clk=count_clk+1;
        }
          else {
    clk=0;
  //  count_clk=0;
  //  pc.printf("\n");
    }
        
        }

    int main ()
    {
    ref0=read_data(2);
    ref1=read_data(3);
    ref2=read_data(4);  
    //ckref.set_frequency(SI5351_CLK0, ref0*1000000);   // CLK0=48MHz
    //ckref.set_frequency(SI5351_CLK1, ref1*1000000);   // CLK0=50MHz
    //ckref.set_frequency(SI5351_CLK2, ref2*1000000);   // CLK0=45MHz
 //   ckref.set_frequency(SI5351_CLK0, 40000000);   // CLK0=48MHz
    ckref.set_frequency(SI5351_CLK1, 4800000);   // CLK0=50MHz
  //  ckref.set_frequency(SI5351_CLK2, 49000000);   // CLK0=45MHz

    data=0;
    clk=0;
    divider= read_data(0);
    div_bin= set_dec2bin(divider);
    mode= read_data(1);
 
    debounce.start();
    button.rise(&toggle); // attach the address of the toggle
    swon=1;
    swled=1;
    wait(1);
    swon=0;
    swled=0;
    while(1) { //begin while
            wait(1);
        }  // end while
     
    }
    
    void toggle() {
    if (debounce.read_ms()>200) // only allow toggle if debounce timer
    data_out.attach(&send_data, 0.01); 
    wait(0.005);
    clock_out.attach(&send_clk, 0.005);
    debounce.reset(); // restart timer when the toggle is performed
    count_data=0;
    count_clk=0;
     swon=1;
    swled=1;
    wait(1);
    swon=0;
    swled=0;
}   
   