#ifndef MBED_LPC_H
#define MBED_LPC_H
#include "mbed.h"

class SerialBuffered {
public:
    SerialBuffered();
    SerialBuffered( size_t bufferSize, PinName tx, PinName rx );
    virtual ~SerialBuffered();
    int getc();                                             // will block till the next character turns up, or return -1 if there is a timeout
    int readable();                                         // returns 1 if there is a character available to read, 0 otherwise
    void setTimeout( float seconds );                       // maximum time in seconds that getc() should block while waiting for a character. Pass -1 to disable the timeout
    size_t readBytes(char *bytes, size_t requested );       //Read requested bytes into a buffer, return number actually read, which may be less than requested if there has been a timeout
    
    void InitUART(int baud);                                //Sets the baud rate to a user-defined value
    void TargetSendString(char string[]);                   //Sends a string to the board
    void TargetSendStringAndCR(char string[]);              //Sends a string to the board followed by a carriage return character
    int CheckTargetPresent(void);                           //Starts the handshaking and then verifies the type of chip from a returned ID code
    int ProgramFile(void);                           //Programs the UUEncoded data onto the RAM and the copies into the flash
    int UUEncode(void);                                     //Encodes the file into UU-encoded format
    int Encode3(void);                                      //Sub-function to UUEncode which encodes the 3 raw bytes into 4 UU-encoded bytes
    int FirstEncode(void);                                  //Encodes the first UUEncoded line which needs the first checksum added to it as the 8th DWORD
    int EndUUEncode(void);                                  //Function to encode the last 124 bytes of the 1024 byte blocks and output to enduuline[]
    int SectorFill(int add);                                //Function to load the data onto the board, keeping track of position in FLASH memory
    int IDCheck(int idcode);                                //Function that looks up the relevant information about the chip from a returned ID code

private:
    FILE *f;                                                //File pointer (binary file for writing to the chip and a temporary file with the checksum-added DWORD)
    int lastSector;                                         //Variable defnining the number of sectors which exist in Flash memory on the specific LPC17xx chip
    char strChipType[80];                                   //Char array containing the chip type
    char fname[64];                                         //Char array containing the file name specified in the main.cpp
    char buf[1024];                                         //Char array containing the currently returned string from the LPC17xx board
    int n1, n2, n3, n4;                                     //UU-Encoded 4 bytes corresponding to the converted 3 raw bytes
    int ch1, ch2, ch3;                                      //3 raw bytes for conversion into the 4 bytes above --^
    int sum20, checksum;                                    //Checksum sent after a certain number of UU-Encoded lines
    bool readAll;                                           //Global variable determining if the file has been encoded and sent fully
    char uuline[64];                                        //Contains the current UU-encoded line to be sent to the board next
    char enduuline[52];                                     //Output array from EndUUEncode()
    char sum[45], sum1[28];                                 //The char arrays assist in the conversion to big-endian for the FirstEncode() function
    unsigned int id;                                        //ID code for the attached chip
    int bytesfilled;                                        //Int to keep track of the position in the 1024 byte block (sets up triggering of switching to EndUUEncode()
    int lines;                                              //Keeps track of the number of lines sent before a checksum (checksum should be sent after every 20 UUline block where possible
    bool firstencode;                                       //True if no encoding of the file has been done
    int maxsector;                                          //Number of sectors required in order to accommodate the program, based on filesize
    long int filesize;                                      //Filesize is the...file...size (number of bytes in the file to load to the chip)
    int RAM;
    char speed[10];
    
    //Serial Buffered
    void handleInterrupt();
    
    uint8_t *m_buff;                                        //Points at a circular buffer, containing data from m_contentStart, for m_contentSize bytes, wrapping when you get to the end
    uint16_t  m_contentStart;                               //Index of first bytes of content
    uint16_t  m_contentEnd;                                 //Index of bytes after last byte of content
    uint16_t m_buffSize;
    float m_timeout;                                        //Can be user-defined
    Timer m_timer;                                          //Timeout timer
    
    Serial target;
};
#endif