#include "mbed.h"
#include "LPC.h"
//Function to document the relevant information on LPC chips to load onto
int SerialBuffered::IDCheck(int idcode) {
    switch (idcode) {
    
        //Cortex M3 - LPC17xx
        case 637615927://Works                           //ID code
            strcpy(strChipType, "LPC1768 - Cortex M3");  //Chip name
            //MAX 230400 baud                            //Maximum baud rate
            lastSector = 29;                             //Last available sector in Flash
            RAM = 0x10000200;                            //First RAM address
            strcpy(speed, "4000");                       //Chip speed
            break;
            
        case 1023410219://Looking at the user manual to solve problems
            strcpy(strChipType, "LPC1343 - Cortex M3");  
            //MAX 115200 baud
            lastSector = 7;
            RAM = 0x10000000;
            strcpy(speed, "60000");                      
            break;
            
        case 71569451://Looking at the user manual to solve problems
            strcpy(strChipType, "LPC1114 - Cortex M3");
            //MAX 115200 baud
            lastSector = 7;
            RAM = 0x10000000;
            strcpy(speed, "4000");                      
            break;
            
        //ARM7
        case 117702437://Works
            //MAX 230400
            strcpy(strChipType, "LPC2387 - ARM7");
            lastSector = 27;
            RAM = 0x40000200;
            strcpy(speed, "4000");                       
            break;
            
        default:
            strcpy(strChipType, "\n\rUnrecognised chip! Please add into the \"CheckTargetPresent\" function the chip's relevant information.\r\n\n");
            return(2);
    }
    return 0;
}