#include "mbed.h"
#include "LPC.h"

Serial pc2(USBTX, USBRX);

SerialBuffered::SerialBuffered( size_t bufferSize, PinName tx, PinName rx ) : target(  tx,  rx ) {
    m_buffSize = 0;
    m_contentStart = 0;
    m_contentEnd = 0;
    m_timeout = 1.0;
    target.attach( this, &SerialBuffered::handleInterrupt );
    m_buff = (uint8_t *) malloc( bufferSize );
    if ( m_buff == NULL ) {
        pc2.printf("\n\rERROR: Failed to alloc serial buffer size of %d\r\n", (int) bufferSize );
    } else {
        m_buffSize = bufferSize;
    }
}

SerialBuffered::~SerialBuffered() {
    if ( m_buff )
        free( m_buff );
}

void SerialBuffered::InitUART(int baud) {  //Sets the baud rates
    pc2.baud(baud);
    target.baud(baud);
}

void SerialBuffered::TargetSendString(char * str) {  //Sends string to the board for console communication
    for (int i=0; i<strlen(str); i++) {
         target.putc(str[i]);
    }
}

void SerialBuffered::TargetSendStringAndCR(char * str) {  //Sends string to the board for console communication followed by the carriage return character
    for (int i=0; i<strlen(str); i++)
        target.putc(str[i]);
    target.putc(0x0D);
}

void SerialBuffered::setTimeout( float seconds ) {
    m_timeout = seconds;
}

size_t SerialBuffered::readBytes(char *bytes, size_t requested) {
    int i = 0;
    for (int a=0; a<m_buffSize; a++)
        bytes[a] = 0;
    for (; i<requested;) {
        int c = getc();
        if (c<0)
            break;
        bytes[i] = c;
        i++;
    }
    return i;
}

int SerialBuffered::getc() {
    m_timer.reset();
    m_timer.start();
    while (m_contentStart == m_contentEnd) {
        wait_ms(1);
        if (m_timeout>0 && m_timer.read()>m_timeout)
            return EOF;
    }
    m_timer.stop();
    uint8_t result = m_buff[m_contentStart++];
    m_contentStart =  m_contentStart % m_buffSize;
    return result;
}

int SerialBuffered::readable() {
    return m_contentStart != m_contentEnd ;
}

void SerialBuffered::handleInterrupt() {
    while (target.readable()) {
        if (m_contentStart == (m_contentEnd +1) % m_buffSize) {
            pc2.printf("\n\rERROR: Serial buffer overrun, data lost!\r\n" );
            exit(0);
        } else {
            m_buff[m_contentEnd++] = target.getc();
            m_contentEnd = m_contentEnd % m_buffSize;
        }
    }
}