#include "mbed.h"
#include "LPC.h"

//ENCODING FUNCTIONS BELOW
int SerialBuffered::UUEncode() {       //Encodes the next 45 bytes in the file into a UUEncoded string with checksum and LF/CR characters ready to be sent to the board
    int loop=0;  int i;  checksum=0;
    for (int a=0; a<=63; a++) uuline[a]=0;
    for (i=0; i<15; i++) {
        if ((ch1=fgetc(f)) == EOF)  //Padded with 0x00 making life easier when the end of the file is reached
            ch1=0x00;
        if ((ch2=fgetc(f)) == EOF)
            ch2=0x00;
        if ((ch3=fgetc(f)) == EOF)
            ch3=0x00;
        checksum +=3;
        Encode3();
        uuline[1+(loop*4)]=n1;
        uuline[2+(loop*4)]=n2;
        uuline[3+(loop*4)]=n3;
        uuline[4+(loop*4)]=n4;
        loop++;
    }
    uuline[0] = checksum+32;
    uuline[61] = 0x0D;
    uuline[62] = 0x0A;
    uuline[63] = 0x00;
    return 0;
}

int SerialBuffered:: Encode3() {   //Does the actual raw encoding. Laid out in a less compact way to explicitly show the process going on
    n1 = 0, n2 = 0, n3 = 0, n4 = 0;
    sum20 += ch1+ch2+ch3;
    if ((ch1-128)>=0)   {ch1-=128;  n1+=32;}
    if ((ch1-64)>=0)    {ch1-=64;   n1+=16;}
    if ((ch1-32)>=0)    {ch1-=32;   n1+=8;}
    if ((ch1-16)>=0)    {ch1-=16;   n1+=4;}
    if ((ch1-8)>=0)     {ch1-=8;    n1+=2;}
    if ((ch1-4)>=0)     {ch1-=4;    n1+=1;}

    if ((ch1-2)>=0)     {ch1-=2;    n2+=32;}
    if ((ch1-1)>=0)     {ch1-=1;    n2+=16;}
    if ((ch2-128)>=0)   {ch2-=128;  n2+=8;}
    if ((ch2-64)>=0)    {ch2-=64;   n2+=4;}
    if ((ch2-32)>=0)    {ch2-=32;   n2+=2;}
    if ((ch2-16)>=0)    {ch2-=16;   n2+=1;}

    if ((ch2-8)>=0)     {ch2-=8;    n3+=32;}
    if ((ch2-4)>=0)     {ch2-=4;    n3+=16;}
    if ((ch2-2)>=0)     {ch2-=2;    n3+=8;}
    if ((ch2-1)>=0)     {ch2-=1;    n3+=4;}
    if ((ch3-128)>=0)   {ch3-=128;  n3+=2;}
    if ((ch3-64)>=0)    {ch3-=64;   n3+=1;}

    if ((ch3-32)>=0)    {ch3-=32;   n4+=32;}
    if ((ch3-16)>=0)    {ch3-=16;   n4+=16;}
    if ((ch3-8)>=0)     {ch3-=8;    n4+=8;}
    if ((ch3-4)>=0)     {ch3-=4;    n4+=4;}
    if ((ch3-2)>=0)     {ch3-=2;    n4+=2;}
    if ((ch3-1)>=0)     {ch3-=1;    n4+=1;}

    if (n1 == 0x00) n1=0x60;
    else n1+=0x20;
    if (n2 == 0x00) n2=0x60;
    else n2+=0x20;
    if (n3 == 0x00) n3=0x60;
    else n3+=0x20;
    if (n4 == 0x00) n4=0x60;
    else n4+=0x20;
    return 0;
}

int SerialBuffered::FirstEncode() {  //Function to add two's complement of the first 7 DWORDs into the space occupied by the 8th DWORD (DWORDs 1-8 should add to zero)
    long int precheck = 0;
    int a;
    for (a=0; a<9; a++) {
        ch1 = fgetc(f);  ch2 = fgetc(f);     ch3 = fgetc(f);
        sum[a*3]=ch1;    sum[(a*3)+1]=ch2;   sum[(a*3)+2]=ch3;
    }
    ch1 = fgetc(f);  fgetc(f);  fgetc(f);  fgetc(f);  fgetc(f);  //Ignores the 4 bytes which are to be overwritten
    sum[27] = ch1;
    
    for (a=0; a<7; a++) {
        sum1[a*4] = sum[a*4+3];
        sum1[a*4+1] = sum[a*4+2];
        sum1[a*4+2] = sum[a*4+1];
        sum1[a*4+3] = sum[a*4];
        precheck += (sum1[a*4]*0x1000000) + (sum1[a*4+1]*0x10000) + (sum1[a*4+2]*0x100) + sum1[a*4+3];
    }
    precheck = ~precheck+1;  //Takes the two's complement of the checksum
    sum[28] = precheck & 0xFF;
    sum[29] = (precheck >> 8) & 0xFF;
    sum[30] = (precheck >>16) & 0xFF;
    sum[31] = (precheck >>24) & 0xFF;
    sum[32] = fgetc(f);
    for (int a=33; a<46; a++) sum[a] = fgetc(f);
    fseek(f, 0, SEEK_END);
    filesize = ftell(f);
    fclose(f);
    f=fopen("/fs/delete.bin", "w");   //Opens a temporary file for writing to
    fwrite (sum, 1, sizeof(sum), f);  //Writes the checksum-added and encoded bytes
    fclose(f);
    f=fopen("/fs/delete.bin", "r");   //Opens the original binary file again for reading
    UUEncode();  
    return 0;
}

int SerialBuffered::EndUUEncode() {  //Encodes the last 124 bytes of a 1024 byte block
    int loop=0;  int i;  checksum=0;
    for (int a=0; a<=50; a++) enduuline[a]=0;
    for (i=1; i<=12; i++) {
        if ((ch1=fgetc(f)) == EOF)
            ch1=0x00;
        if ((ch2=fgetc(f)) == EOF)
            ch2=0x00;
        if ((ch3=fgetc(f)) == EOF)
            ch3=0x00;
        checksum +=3;
        if (loop==11) {
            checksum-=2;
            fseek (f, -2, SEEK_CUR);
            ch2=0x00; ch3=0x00;
        }
        Encode3();
        enduuline[1+(loop*4)]=n1;
        enduuline[2+(loop*4)]=n2;
        enduuline[3+(loop*4)]=n3;
        enduuline[4+(loop*4)]=n4;
        loop++;
    }
    enduuline[0] = checksum+32;
    enduuline[49] = 0x0D;
    enduuline[50] = 0x0A;
    enduuline[51] = 0x00;
    return 0;
}