#include "mbed.h"
#include "TextLCD.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"
#include "SDFileSystem.h"
// wind data receiver (not SDcard logger)
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
SDFileSystem sd(p5, p6, p7, p8, "sd");
TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d4-d7

Serial pc(USBTX, USBRX);
Serial xbee(p13,p14);

#define PI 3.1415926535

int main() {
  PHY_PowerDown();
  myled1=1;
  myled2=0;
  myled3=0;
  myled4=0;
  
  pc.baud(9600);
  xbee.baud(9600);
  
  
  //wind data value
  int i=0;
  int j=0;
  int h=0;
  int k=0;
  
  char wind_data[256];
  float windvel_5min_ave=0.0,windvel_5sec_ave=0.0;
  float winddeg_5sec_ave=0.0,winddeg_5min_ave=0.0;
  char winddeg_5min_ave_c[4],winddeg_5sec_ave_c[4];
  float winddeg,windvel;
  float windvel_5sec[6],windvel_5min[301];
  float winddeg_5sec[6],winddeg_5min[301];
  for(i=0; i<=5; i++){windvel_5sec[i]=0.0; winddeg_5sec[i]=0.0;}
  for(i=0; i<=300; i++){windvel_5min[i]=0.0; winddeg_5min[i]=0.0;}
  char ms,check;

   //LCD startup
    lcd.cls();
         
    lcd.locate(0,0);
    lcd.printf("-Windmeter LCD!-");
      
    lcd.locate(0,1);
    lcd.printf("-----Ready!-----");
    wait(2);

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("------Wait------");
    lcd.locate(0,1);
    lcd.printf("----no data!----");    
    
    char idir[14] = "/sd/";
    char time_c[7],date_c[9];
    
    //sprintf(date_c,"%4d%2d%2d",y_date,m_date,d_date);
    //sprintf(time_c,"%2d%2d%2d",h_time,m_time,s_time);
    
    char filename[15] = "";
    strcat(filename,date_c);
    strcat(filename,time_c);
    
    char dir[100] = "";
    strcat(idir,date_c);
    mkdir(idir, 0777);
    
    strcat(dir,idir);
    strcat(dir,"/");
    strcat(dir,filename);
    strcat(dir,".csv");
    
    FILE *fp = fopen(dir, "w");
    if(fp == NULL) {
        error("Could not open file for write\r\n");
        myled3 = 1;
    }
    //fprintf(fp, "Year,Month,Day,hh:mm:ss,wind_velocity[m/s],wind_velocity_5sec[m/s],wind_velocity_5min[m/s],wind_direction[deg],wind_direction_5sec[deg],wind_direction_5min[deg],Atmospheric Pressure[Pa],Temperature[degC]\n");
    fprintf(fp, "Year,Month,Day,hh:mm:ss,wind_velocity[m/s],wind_direction[deg],wind_velocity_5sec[m/s],wind_direction_5sec[deg],wind_velocity_5min[m/s],wind_direction_5min[deg]\n");
    
    fclose(fp);   
//------------------------------------------- main while loop
    while(1){
        //先頭の文字判定
        myled1=0;
        while(xbee.getc()!='Q'){}
        myled1=1;
        
        //文字列終わり（改行）まで文字列格納
        i=0;
        while( (wind_data[i]=xbee.getc()) != '\r'){
            i++;
            if(i==256){
                //lcd.locate(0,1);
                //lcd.printf("Data read  Error");
                i=255;
                break;
            }
        }
        
        myled1 = 0;
        wind_data[i]='\0';
        if(i<=256){
          if( sscanf(wind_data, ",%f,%f,%c,%f",&winddeg,&windvel,&ms,&check) >= 1){
             if( check == 0 ){ 
                windvel_5sec[j] = windvel;
                winddeg_5sec[j] = winddeg;
                windvel_5min[k] = windvel;
                winddeg_5min[k] = winddeg;
                
                j++;
                k++;
                if(j==5){j=1;}
                if(k==300){k=1;}
              
                for(i=1; i<=5; i++){windvel_5sec_ave +=windvel_5sec[i];}
                for(i=1; i<=5; i++){winddeg_5sec_ave +=winddeg_5sec[i];}
                windvel_5sec_ave /= 5.0;
                winddeg_5sec_ave /= 5.0;
                for(i=1; i<=300; i++){windvel_5min_ave +=windvel_5min[i];}
                for(i=1; i<=300; i++){winddeg_5min_ave +=winddeg_5min[i];}
                windvel_5min_ave /= 300.0;
                winddeg_5min_ave /= 300.0;
                if(winddeg_5sec_ave>348.75 || winddeg_5sec_ave<=11.25){strcpy(winddeg_5sec_ave_c,"N  ");}
                if(winddeg_5sec_ave>11.25 && winddeg_5sec_ave<=33.75){strcpy(winddeg_5sec_ave_c,"NNE");}
                if(winddeg_5sec_ave>33.75 && winddeg_5sec_ave<=56.25){strcpy(winddeg_5sec_ave_c,"NE ");}
                if(winddeg_5sec_ave>56.25 && winddeg_5sec_ave<=78.75){strcpy(winddeg_5sec_ave_c,"ENE");}
                if(winddeg_5sec_ave>78.75 && winddeg_5sec_ave<=101.25){strcpy(winddeg_5sec_ave_c,"E  ");}
                if(winddeg_5sec_ave>101.25 && winddeg_5sec_ave<=123.75){strcpy(winddeg_5sec_ave_c,"ESE");}
                if(winddeg_5sec_ave>123.75 && winddeg_5sec_ave<=146.25){strcpy(winddeg_5sec_ave_c,"SE ");}
                if(winddeg_5sec_ave>146.25 && winddeg_5sec_ave<=168.75){strcpy(winddeg_5sec_ave_c,"SSE");}
                if(winddeg_5sec_ave>168.75 && winddeg_5sec_ave<=191.25){strcpy(winddeg_5sec_ave_c,"S  ");}
                if(winddeg_5sec_ave>191.25 && winddeg_5sec_ave<=213.75){strcpy(winddeg_5sec_ave_c,"SSW");}
                if(winddeg_5sec_ave>213.75 && winddeg_5sec_ave<=236.25){strcpy(winddeg_5sec_ave_c,"SW ");}
                if(winddeg_5sec_ave>236.25 && winddeg_5sec_ave<=258.75){strcpy(winddeg_5sec_ave_c,"WSW");}
                if(winddeg_5sec_ave>258.75 && winddeg_5sec_ave<=281.25){strcpy(winddeg_5sec_ave_c,"W  ");}
                if(winddeg_5sec_ave>281.25 && winddeg_5sec_ave<=303.75){strcpy(winddeg_5sec_ave_c,"WNW");}
                if(winddeg_5sec_ave>303.75 && winddeg_5sec_ave<=326.25){strcpy(winddeg_5sec_ave_c,"NW ");}
                if(winddeg_5sec_ave>326.25 && winddeg_5sec_ave<=348.75){strcpy(winddeg_5sec_ave_c,"NNW");}
                
                if(winddeg_5min_ave>348.75 || winddeg_5min_ave<=11.25){strcpy(winddeg_5min_ave_c,"N  ");}
                if(winddeg_5min_ave>11.25 && winddeg_5min_ave<=33.75){strcpy(winddeg_5min_ave_c,"NNE");}
                if(winddeg_5min_ave>33.75 && winddeg_5min_ave<=56.25){strcpy(winddeg_5min_ave_c,"NE ");}
                if(winddeg_5min_ave>56.25 && winddeg_5min_ave<=78.75){strcpy(winddeg_5min_ave_c,"ENE");}
                if(winddeg_5min_ave>78.75 && winddeg_5min_ave<=101.25){strcpy(winddeg_5min_ave_c,"E  ");}
                if(winddeg_5min_ave>101.25 && winddeg_5min_ave<=123.75){strcpy(winddeg_5min_ave_c,"ESE");}
                if(winddeg_5min_ave>123.75 && winddeg_5min_ave<=146.25){strcpy(winddeg_5min_ave_c,"SE ");}
                if(winddeg_5min_ave>146.25 && winddeg_5min_ave<=168.75){strcpy(winddeg_5min_ave_c,"SSE");}
                if(winddeg_5min_ave>168.75 && winddeg_5min_ave<=191.25){strcpy(winddeg_5min_ave_c,"S  ");}
                if(winddeg_5min_ave>191.25 && winddeg_5min_ave<=213.75){strcpy(winddeg_5min_ave_c,"SSW");}
                if(winddeg_5min_ave>213.75 && winddeg_5min_ave<=236.25){strcpy(winddeg_5min_ave_c,"SW ");}
                if(winddeg_5min_ave>236.25 && winddeg_5min_ave<=258.75){strcpy(winddeg_5min_ave_c,"WSW");}
                if(winddeg_5min_ave>258.75 && winddeg_5min_ave<=281.25){strcpy(winddeg_5min_ave_c,"W  ");}
                if(winddeg_5min_ave>281.25 && winddeg_5min_ave<=303.75){strcpy(winddeg_5min_ave_c,"WNW");}
                if(winddeg_5min_ave>303.75 && winddeg_5min_ave<=326.25){strcpy(winddeg_5min_ave_c,"NW ");}
                if(winddeg_5min_ave>326.25 && winddeg_5min_ave<=348.75){strcpy(winddeg_5min_ave_c,"NNW");}
                      
                if(h>=9) {h=0;}
                else {h++;}       
          
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("5s:%5.2fm/s %s",windvel_5sec_ave,winddeg_5sec_ave_c);
                lcd.locate(0,1);
                lcd.printf("5m:%5.2fm/s %s%d",windvel_5min_ave,winddeg_5min_ave_c,h);
              }//end if check
              else
              {
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("-Windmeter LCD!-");
                lcd.locate(0,1);
                lcd.printf("Data read  Error");                
              }
          } //end if sscanf
        } //end if i<=256
        strcpy(winddeg_5sec_ave_c,"    ");
        strcpy(winddeg_5min_ave_c,"    ");
        for(i=0; i<=256; i++) wind_data[i] = 0;
    }//end while(1)
//---------------------------------------main while loop end
/*
    while(1) {
        myled1 = 1;
        wait(0.2);
        myled1 = 0;
        wait(0.2);
    }
*/
}