#include "mbed.h"
#include "wave_player.h"
#include "SDFileSystem.h"

SDFileSystem sd(p5, p6, p7, p8, "sd");
AnalogOut       DACout(p18);
wave_player     waver(&DACout);

int main() {

    mkdir("/sd/wf/", 0777);     // make the directory to the SD card
                                // 0777 is the default mode so to have the widest access 
                              
    FILE  *fp = fopen("/sd/wf/Hello.wav", "r");
    
    if(fp == NULL){
    printf("File couldn't open\n");
    }
    
    while (1)
    {
      waver.play(fp);
      fseek(fp, 0, SEEK_SET);  // set file poiter to beginning
      wait(3.0);
      printf("File Playing\n");
    }
    fclose(fp);
} 