#include "mbed.h"
#include "scmRTOS.h"
#include "wave_player.h"
#include "SDHCFileSystem.h"
#include "keypad.h"

BusOut     SevenSegments(p21, p22, p23, p24, p25, p26, p27);
BusOut     Leds(p28, p29, p30);
Keypad     keypad(p15, p14, p13, p12, p20, p19, p17, p16);

Serial          xbee(p9, p10);
DigitalOut      rst1(p11);
SDFileSystem    sd(p5, p6, p7, p8, "sd");
AnalogOut       AudioOut(p18);
wave_player     waver(&AudioOut);


#define  MAXBUS     2
#define  MAXLEN     4
#define  ENDKEYIX  14
char     BusNumber[MAXBUS][MAXLEN];
char     BusInput[MAXLEN];
volatile char     BusDisplay[MAXLEN]; // Updated by ISR?? for 7-segment LED refresh
char     Keytable[] = { 0x30, 0x6D, 0x79, 0x00,
                        0x33, 0x5B, 0x5F, 0x00,
                        0x70, 0xFF, 0x7B, 0x00,
                        0x00, 0x75, 0x00, 0x00
                      };


int req;
/*
 * ISR to update completed bus number input into BusNumer[][]
 */
uint32_t cbAfterInput(uint32_t keyIX) {
    bool     finish = false;
    static int NumIX = 0;    // Point to current index of Bus number

    if (NumIX < MAXLEN - 1) {
        if (keyIX != ENDKEYIX) {
            BusInput[NumIX] = Keytable[keyIX];
            //printf("Entered = %02X\n", BusInput[NumIX]);
            NumIX++;
        } else {
            finish = true;
        }
    }

    if (finish || NumIX == MAXLEN - 1) {
        int i;
        for (i = 0; i < MAXBUS; i++) {
            if ( (BusNumber[i][0] == 0)) {
                memcpy((void *) &BusNumber[i][0], &BusInput[0], 3);
                printf("Entered %02X%02X%02X\n",
                       BusNumber[i][0], BusNumber[i][1], BusNumber[i][2]);
                break;
            }
        }
        if (i == MAXBUS -1)
            printf("BusNumber buffer is full\n");

        NumIX = 0;
    }
    return 0;
}

/*
 * Update a bus number into BusDisplay for 7-segment LED
 */
void Refresh7SegmentLedISR() {
    if (BusDisplay[0] != 0) {
        printf("BusDisplay %02X%02X%02X\n",
               BusDisplay[0],BusDisplay[1],BusDisplay[2]);
        for (int i = 0; i< MAXLEN-1; i++) {
            Leds = 0x01 << i;
            SevenSegments = BusDisplay[i];
            wait_ms(50); // Change to Sleep(20000) in RTOS
        }
    }
}

void UpdateBusDisplayISR() {
    static  int BusIX = -1;

    BusIX = ++BusIX % MAXBUS;

    if (BusNumber[BusIX][0] != 0)
        memcpy((void *)BusDisplay, BusNumber[BusIX], MAXLEN);
}


Ticker   UpdateBusDisplay;
Ticker   Refresh7SegmentLed;

//---------------------------------------------------------------------------
//
//      Process types
//
typedef OS::process<OS::pr0, 5000> TProc1;
typedef OS::process<OS::pr1, 3000> TProc2;
typedef OS::process<OS::pr2, 3000> TProc3;

//---------------------------------------------------------------------------
//
//      Process objects
//
TProc1 Proc1;
TProc2 Proc2;
TProc3 Proc3;

//---------------------------------------------------------------------------
//
//      IO Pins
//
DigitalOut led1(LED1);
DigitalOut led2(LED2);

//---------------------------------------------------------------------------
//
//      Event Flags to test
//
OS::TEventFlag XBee;


//---------------------------------------------------------------------------
//
int main() {
    // configure IO pins
    //printf("\nInitialising ...\n");
    rst1   = 0; //Set reset pin to 0
    led1  = 0;//Set LED1 to 0
    led2 = 0;//Set LED2 to 0
    wait_ms(1);//Wait at least one millisecond
    rst1   = 1;//Set reset pin to 1
    wait_ms(1);//Wait another millisecond

    // run
    OS::Run();
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc1::Exec() {

    for (;;) {
        if (xbee.readable()) {
            req = xbee.getc();
            //printf("req = %c\n", req);
            XBee.SignalISR();
            Sleep(2000);
        }
    }
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc2::Exec() {
    for (;;) {
        XBee.Wait();
        if (req == 'r') {
            //printf("Came here 2 \n");
            FILE *fp = fopen("/sd/wf/Bus.wav","r");
            waver.play(fp);
            //printf("playing");
            fseek(fp, 0, SEEK_SET);
            fclose(fp);
            FILE *fp1 = fopen("/sd/wf/30.wav","r");
            waver.play(fp1);
            fseek(fp1, 0, SEEK_SET);
            fclose(fp1);
            FILE *fp2 = fopen("/sd/wf/coming.wav","r");
            waver.play(fp2);
            fseek(fp2, 0, SEEK_SET);
            fclose(fp2);
        }
    }
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc3::Exec() {

    for (;;) {
        printf("Start\n");
        UpdateBusDisplay.attach(&UpdateBusDisplayISR, 1.0);
        Refresh7SegmentLed.attach(&Refresh7SegmentLedISR, 1.3);

        memset((void*)BusNumber, 0, MAXBUS * MAXLEN);
        memset((void*)BusInput,  0, MAXLEN);
        memset((void*)BusDisplay, 0, MAXLEN);
        keypad.CallAfterInput(&cbAfterInput);
        keypad.Start();
    }
}
/*
//---------------------------------------------------------------------------
void OS::SystemTimerUserHook() {
    static int cnt=0;
    if (++cnt == 2000) {
        cnt = 0;
        led2.write(1);

    }
}
*/
//---------------------------------------------------------------------------
void OS::IdleProcessUserHook() {
    __WFI();
}
//-----------------------------------------------------------------------------
