/*
Final Year Project for Ngee Ann Polytechnic Electrical Engineering Year 3
Project Title: Bus Assistance for the Visually Impaired
*/
#include "mbed.h"
#include "scmRTOS.h"
#include "wave_player.h"
#include "SDHCFileSystem.h"
#include "keypad.h"
#include "TextLCD.h"

Serial          xbee(p9, p10);
DigitalOut      rst1(p11);
SDFileSystem    sd(p5, p6, p7, p8, "sd");
AnalogOut       AudioOut(p18);
wave_player     waver(&AudioOut);
//Keypad          keypad( p24, p23, p22, p21, p28, p27, p26, p25);
TextLCD         lcd(p15, p16, p17, p18, p19, p20);
DigitalOut      myled(LED1);//Create variable for Led 1 on the mbed
DigitalOut      myled1(LED2);//Create variable for Led 2 on the mbed
//BusOut          seven(p27, p26, p25, p24, p23, p22, p21);
//BusOut          leds(p28, p29, p30);

DigitalOut      led(LED1);
DigitalOut      led1(LED2);

//OS Timer/interrupt
OS::TEventFlag XBee;

// process types
//typedef OS::process<OS::pr1, 5000> TProc1;  //7 Segment LED
typedef OS::process<OS::pr0, 4000> TProc2; // XBee Communication
//typedef OS::process<OS::pr0, 8000> TProc3;  // Playing of Audio
//typedef OS::process<OS::pr0  1000> TProc4;  // Interrupt of Keypad

// process objects
//TProc1 Proc1;
TProc2 Proc2;
//TProc3 Proc3;
//TProc4 Proc4

#define  MAXBUS    10
#define  MAXLEN     4
#define  ENDKEY    14
int      req;
char     Bus[MAXBUS][MAXLEN];
char     NumIx = 0;   // Point to current index of Bus number
char     BusIx = 0;   // Point to current bus
bool     BusFull = false;  // Bus number buffer is full
char     KeyCh;


char     Keytable[] = { '1', '2', '3', 'A',
                        '4', '5', '6', 'B',
                        '7', '8', '9', 'C',
                        '*', '0', '#', 'D'
                      };

uint32_t cbAfterInput(uint32_t key) {
    KeyCh = Keytable[key];

    if (BusFull) {
        printf("Bus number is already full\n");
        return 2;
    }


    if (NumIx < MAXLEN - 1) {
        if (key != ENDKEY) { // Terminating key
            lcd.putc(KeyCh);
            printf("%c", KeyCh);


        } else { // Terminating key is entered
            printf("\nBus(%d,%d)=%c\n", BusIx, NumIx, KeyCh);
            BusIx++;
            NumIx = 0;
        }
    }
    return 0;
}

//---------------------------------------------------------------------------
long long count = 0;

int main() {
    printf("\nInitialising ...\n");
    rst1   = 0; //Set reset pin to 0
    myled  = 0;//Set LED1 to 0
    myled1 = 0;//Set LED2 to 0
    wait_ms(1);//Wait at least one millisecond
    rst1   = 1;//Set reset pin to 1
    wait_ms(1);//Wait another millisecond
    OS::Run();
    memset(&Bus, 0, MAXBUS * MAXLEN);
    //seven = Bus[BusIx][NumIx];

}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc1::Exec() {
    int i;
    int n = 1;
    for (;;) {            // toggling between 7 seg led
        for (int i=0; i<3; i++) {
            leds = 0x01 << n;
            n = (++n) % 3;
            seven = Bus[BusIx][NumIx];

        }
    }
} 

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc2::Exec() {

    for (;;) {
        if (xbee.readable()) {
            req = xbee.getc();
            printf("req = %c\n", req);
            //XBee.SignalISR();
            Sleep(2000);
        }
    }
}


//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc3::Exec() {

    for (;;) {
    
        if (req == 'r') {
            printf("Came here 2 \n");
            FILE *fp = fopen("/sd/wf/Bus.wav","r");
            waver.play(fp);
            printf("playing");
            fseek(fp, 0, SEEK_SET);
            fclose(fp);

    }
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc4::Exec() {

    keypad.CallAfterInput(&cbAfterInput);
    keypad.Start();
    while (1) {
        wait_ms(100);
    }
}

//---------------------------------------------------------------------------
void OS::SystemTimerUserHook() {
    ++count;
    if (count % 2000 == 0) {
        printf("\n%lld\n", count);
        }
    }
}
//---------------------------------------------------------------------------
void OS::IdleProcessUserHook() {
    __WFI();
}